/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.decoration.copycat;

import com.simibubi.create.content.decoration.copycat.CopycatModel;
import com.simibubi.create.content.decoration.copycat.CopycatStepBlock;
import com.simibubi.create.foundation.model.BakedModelHelper;
import com.simibubi.create.foundation.model.BakedQuadHelper;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.data.Iterate;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.data.ModelData;

public class CopycatStepModel
extends CopycatModel {
    protected static final Vec3 VEC_Y_3 = new Vec3(0.0, 0.75, 0.0);
    protected static final Vec3 VEC_Y_2 = new Vec3(0.0, 0.5, 0.0);
    protected static final Vec3 VEC_Y_N2 = new Vec3(0.0, -0.5, 0.0);
    protected static final AABB CUBE_AABB = new AABB(BlockPos.ZERO);

    public CopycatStepModel(BakedModel originalModel) {
        super(originalModel);
    }

    @Override
    protected List<BakedQuad> getCroppedQuads(BlockState state, Direction side, RandomSource rand, BlockState material, ModelData wrappedData, RenderType renderType) {
        Direction facing = state.getOptionalValue((Property)CopycatStepBlock.FACING).orElse(Direction.SOUTH);
        boolean upperHalf = state.getOptionalValue(CopycatStepBlock.HALF).orElse(Half.BOTTOM) == Half.TOP;
        BakedModel model = CopycatStepModel.getModelOf(material);
        List templateQuads = model.getQuads(material, side, rand, wrappedData, renderType);
        int size = templateQuads.size();
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        Vec3 normal = Vec3.atLowerCornerOf((Vec3i)facing.getNormal());
        Vec3 normalScaled2 = normal.scale(0.5);
        Vec3 normalScaledN3 = normal.scale(-0.75);
        AABB bb = CUBE_AABB.contract(-normal.x * 0.75, 0.75, -normal.z * 0.75);
        for (boolean top : Iterate.trueAndFalse) {
            for (boolean front : Iterate.trueAndFalse) {
                AABB bb1 = bb;
                if (front) {
                    bb1 = bb1.move(normalScaledN3);
                }
                if (top) {
                    bb1 = bb1.move(VEC_Y_3);
                }
                Vec3 offset = Vec3.ZERO;
                if (front) {
                    offset = offset.add(normalScaled2);
                }
                if (top != upperHalf) {
                    offset = offset.add(upperHalf ? VEC_Y_2 : VEC_Y_N2);
                }
                for (int i = 0; i < size; ++i) {
                    BakedQuad quad = (BakedQuad)templateQuads.get(i);
                    Direction direction = quad.getDirection();
                    if (front && direction == facing || !front && direction == facing.getOpposite() || !top && direction == Direction.UP || top && direction == Direction.DOWN) continue;
                    quads.add(BakedQuadHelper.cloneWithCustomGeometry(quad, BakedModelHelper.cropAndMove(quad.getVertices(), quad.getSprite(), bb1, offset)));
                }
            }
        }
        return quads;
    }
}

