/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.utility;

import com.copycatsplus.copycats.foundation.copycat.ICopycatBlockEntity;
import com.copycatsplus.copycats.foundation.copycat.multistate.IMultiStateCopycatBlockEntity;
import com.copycatsplus.copycats.mixin.foundation.copycat.BlockEntityAccessor;
import com.copycatsplus.copycats.utility.neoforge.BlockEntityUtilsImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BlockEntityUtils {
    public static void redraw(BlockEntity blockEntity) {
        Level level = blockEntity.getLevel();
        if (level != null) {
            if (level.isClientSide()) {
                BlockEntityUtils.requestModelDataUpdate(blockEntity);
            } else {
                blockEntity.setChanged();
            }
            BlockState state = blockEntity.getBlockState();
            level.sendBlockUpdated(blockEntity.getBlockPos(), state, state, 16);
            BlockEntityUtils.updateLight(blockEntity);
        }
    }

    public static void saveMetadata(BlockEntity blockEntity, CompoundTag tag) {
        ((BlockEntityAccessor)blockEntity).callSaveMetadata(tag);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void requestModelDataUpdate(BlockEntity blockEntity) {
        BlockEntityUtilsImpl.requestModelDataUpdate(blockEntity);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void updateLight(BlockEntity blockEntity) {
        BlockEntityUtilsImpl.updateLight(blockEntity);
    }

    public static int getLightEmission(BlockEntity blockEntity) {
        if (blockEntity instanceof IMultiStateCopycatBlockEntity) {
            IMultiStateCopycatBlockEntity multiStateBE = (IMultiStateCopycatBlockEntity)blockEntity;
            int light = 0;
            for (BlockState material : multiStateBE.getMaterialItemStorage().getAllMaterials()) {
                light = Math.max(light, material.getLightEmission((BlockGetter)multiStateBE.getLevel(), multiStateBE.getBlockPos()));
            }
            return light;
        }
        if (blockEntity instanceof ICopycatBlockEntity) {
            ICopycatBlockEntity copycatBE = (ICopycatBlockEntity)blockEntity;
            return copycatBE.getMaterial().getLightEmission((BlockGetter)copycatBE.getLevel(), copycatBE.getBlockPos());
        }
        return 0;
    }
}

