/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.network.handler;

import dev.terminalmc.clientsort.ClientSort;
import dev.terminalmc.clientsort.exception.PayloadHandlerException;
import dev.terminalmc.clientsort.platform.Services;
import java.util.function.Function;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract class PayloadHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processPayload(MinecraftServer server, ServerPlayer player, int containerId, ThrowingConsumer<AbstractContainerMenu> contextValidator, ThrowingConsumer<AbstractContainerMenu> schemaValidator, ThrowingConsumer<AbstractContainerMenu> operator, CustomPacketPayload.Type<?> responseType, Function<String, CustomPacketPayload> responseGenerator) {
        AbstractContainerMenu menu = null;
        String error = null;
        try {
            menu = PayloadHandler.getMenu(player, containerId);
            menu.suppressRemoteUpdates();
            contextValidator.accept(menu);
            schemaValidator.accept(menu);
            operator.accept(menu);
        }
        catch (Exception e) {
            if (e instanceof PayloadHandlerException) {
                PayloadHandlerException se = (PayloadHandlerException)e;
                error = se.getMessage();
            } else {
                error = PayloadHandlerException.GENERIC_MESSAGE;
                ClientSort.LOG.error("Encountered an exception while handling '{}' payload from player '{}'", responseType.id(), player, e);
            }
        }
        finally {
            if (menu != null) {
                menu.resumeRemoteUpdates();
                menu.broadcastChanges();
            }
            if (Services.PLATFORM.canSendToPlayer(player, responseType)) {
                Services.PLATFORM.sendToPlayer(player, responseGenerator.apply(error));
            }
        }
    }

    @NotNull
    private static AbstractContainerMenu getMenu(ServerPlayer player, int containerId) throws PayloadHandlerException {
        InventoryMenu menu;
        if (containerId == player.inventoryMenu.containerId) {
            menu = player.inventoryMenu;
        } else if (containerId == player.containerMenu.containerId) {
            menu = player.containerMenu;
        } else {
            throw new PayloadHandlerException(String.format("Container ID '%d' does not match player inventory or container!", containerId));
        }
        if (!menu.stillValid((Player)player)) {
            throw new PayloadHandlerException(String.format("Container ID '%d' is not valid for the player!", containerId));
        }
        return menu;
    }

    public static boolean notEqual(ItemStack a, ItemStack b) {
        return !ItemStack.isSameItemSameComponents((ItemStack)a, (ItemStack)b) || a.getCount() != b.getCount();
    }

    @FunctionalInterface
    public static interface ThrowingConsumer<T> {
        public void accept(T var1) throws Exception;
    }
}

