/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.mixin.client;

import dev.terminalmc.clientsort.client.ClientSort;
import dev.terminalmc.clientsort.client.config.Config;
import dev.terminalmc.clientsort.client.network.InteractionManager;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.network.protocol.game.ClientboundLoginPacket;
import net.minecraft.network.protocol.game.ClientboundSetCarriedItemPacket;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientPacketListener.class})
public abstract class ClientPacketListenerMixin {
    @Inject(method={"handleLogin"}, at={@At(value="HEAD")})
    private void beforeLogin(ClientboundLoginPacket packet, CallbackInfo ci) {
        ClientSort.searchOrderUpdated = false;
        ClientSort.operatingClient = false;
    }

    @Inject(method={"handleLogin"}, at={@At(value="RETURN")})
    private void afterLogin(ClientboundLoginPacket packet, CallbackInfo ci) {
        ClientSort.updateItemTags(Config.options());
        ClientSort.updateItemSets(Config.options());
    }

    @Inject(method={"handleSetCarriedItem"}, at={@At(value="HEAD")})
    public void beforeHeldItemChange(ClientboundSetCarriedItemPacket packet, CallbackInfo ci) {
        InteractionManager.triggerSend(InteractionManager.TriggerType.HELD_ITEM_CHANGE);
    }

    @Inject(method={"handleContainerSetSlot"}, at={@At(value="RETURN")})
    public void beforeSlotItemChange(ClientboundContainerSetSlotPacket packet, CallbackInfo ci) {
        InteractionManager.triggerSend(InteractionManager.TriggerType.CONTAINER_SLOT_UPDATE);
    }
}

