/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.clientsort.client.gui.widget;

import dev.terminalmc.clientsort.client.config.ClassPolicy;
import dev.terminalmc.clientsort.client.config.Config;
import dev.terminalmc.clientsort.client.config.Policy;
import dev.terminalmc.clientsort.client.config.Vec2i;
import dev.terminalmc.clientsort.client.gui.widget.TriggerButton;
import dev.terminalmc.clientsort.client.inventory.operator.Operation;
import dev.terminalmc.clientsort.client.inventory.operator.SingleUseOperator;
import dev.terminalmc.clientsort.client.inventory.screen.ContainerScreenHelper;
import dev.terminalmc.clientsort.client.order.SortOrder;
import java.util.Collection;
import java.util.TreeSet;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.Nullable;

public class SortButton
extends TriggerButton {
    private static final WidgetSprites SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"clientsort", (String)"widget/sort"), ResourceLocation.fromNamespaceAndPath((String)"clientsort", (String)"widget/sort_disabled"), ResourceLocation.fromNamespaceAndPath((String)"clientsort", (String)"widget/sort_highlighted"));

    public SortButton(AbstractContainerScreen<?> screen, Container container, Slot referenceSlot, boolean isPlayerInv, @Nullable ClassPolicy policy, String lowestPolicyKey, Vec2i offset) {
        super(screen, container, referenceSlot, isPlayerInv, SPRITES, policy == null ? null : policy.className(), lowestPolicyKey, offset, policy == null || policy.canSort(), policy != null && policy.showSortButton(), button -> {
            SortOrder sortOrder = Screen.hasShiftDown() ? Config.options().shiftSortOrder : (Screen.hasControlDown() ? Config.options().ctrlSortOrder : (Screen.hasAltDown() ? Config.options().altSortOrder : Config.options().sortOrder));
            @Nullable SingleUseOperator<Operation> operator = SingleUseOperator.getOperator(screen, ContainerScreenHelper.of(screen), referenceSlot, Operation.SORT);
            if (operator != null) {
                operator.trySort(sortOrder);
            }
        });
    }

    @Override
    public boolean getPolicyStatus(ClassPolicy policy) {
        return policy.showSortButton();
    }

    @Override
    public void savePolicy(@Nullable Vec2i offset, Collection<Integer> slots) {
        @Nullable ClassPolicy policy = null;
        if (this.activePolicyKey != null) {
            policy = Config.options().classPolicies.get(this.activePolicyKey);
        }
        if (policy != null) {
            Config.options().classPolicies.put(this.activePolicyKey, new ClassPolicy(this.activePolicyKey, offset, this.operationAllowed ? (this.active ? Policy.KEYBIND_BUTTON : Policy.KEYBIND) : Policy.NONE, policy.stackFillPolicy(), policy.matchTransferPolicy(), policy.transferPolicy(), new TreeSet<Integer>(slots)));
        } else {
            Config.options().classPolicies.put(this.lowestPolicyKey, new ClassPolicy(this.lowestPolicyKey, offset, this.operationAllowed ? (this.active ? Policy.KEYBIND_BUTTON : Policy.KEYBIND) : Policy.NONE, Policy.KEYBIND, Policy.KEYBIND, Policy.KEYBIND, new TreeSet<Integer>(slots)));
        }
        Config.save();
    }
}

