/*
 * Decompiled with CFR 0.152.
 */
package net.unusual.blockfactorysbosses.network;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.unusual.blockfactorysbosses.BlockFactorysBossesMod;
import net.unusual.blockfactorysbosses.procedures.DodgeRollOnKeyPressedProcedure;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record DodgeRollMessage(int eventType, int pressedms) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<DodgeRollMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"block_factorys_bosses", (String)"key_dodge_roll"));
    public static final StreamCodec<RegistryFriendlyByteBuf, DodgeRollMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.eventType);
        buffer.writeInt(message.pressedms);
    }, buffer -> new DodgeRollMessage(buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<DodgeRollMessage> type() {
        return TYPE;
    }

    public static void handleData(DodgeRollMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> DodgeRollMessage.pressAction(context.player(), message.eventType, message.pressedms)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void pressAction(Player entity, int type, int pressedms) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        if (!world.hasChunkAt(entity.blockPosition())) {
            return;
        }
        if (type == 0) {
            DodgeRollOnKeyPressedProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        BlockFactorysBossesMod.addNetworkMessage(TYPE, STREAM_CODEC, DodgeRollMessage::handleData);
    }
}

