/*
 * Decompiled with CFR 0.152.
 */
package net.unusual.blockfactorysbosses.item;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.unusual.blockfactorysbosses.SandwormDartItemRenderer;
import net.unusual.blockfactorysbosses.init.BlockFactorysBossesModItems;
import net.unusual.blockfactorysbosses.procedures.SandwormDartPlayerFinishesUsingItemProcedure;
import net.unusual.blockfactorysbosses.procedures.SandwormDartRightclickedProcedure;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class SandwormDartItem
extends Item {
    public static final Map<String, AnimationState> IDLE_STATES = new WeakHashMap<String, AnimationState>();
    public static final Map<String, AnimationState> SWING_STATES = new WeakHashMap<String, AnimationState>();
    public static final Map<String, AnimationState> SUCK_STATES = new WeakHashMap<String, AnimationState>();
    public static final Map<ItemStack, Integer> IS_MINING = new WeakHashMap<ItemStack, Integer>();

    public SandwormDartItem() {
        super(new Item.Properties().durability(980).rarity(Rarity.UNCOMMON));
    }

    public int getEnchantmentValue() {
        return 1;
    }

    public int getBarColor(ItemStack stack) {
        return 9697806;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.translatable((String)"item.block_factorys_bosses.sandworm_dart.description_0"));
        list.add((Component)Component.translatable((String)"item.block_factorys_bosses.sandworm_dart.description_1"));
        list.add((Component)Component.translatable((String)"item.block_factorys_bosses.sandworm_dart.description_2"));
        list.add((Component)Component.translatable((String)"item.block_factorys_bosses.sandworm_dart.description_3"));
        list.add((Component)Component.translatable((String)"item.block_factorys_bosses.sandworm_dart.description_4"));
    }

    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(itemstack, world, entity, slot, selected);
        if (((CustomData)itemstack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getString("itemKey").isEmpty()) {
            CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)itemstack, tag -> tag.putString("itemKey", UUID.randomUUID().toString()));
        }
        String key = ((CustomData)itemstack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getString("itemKey");
        int is_mining = IS_MINING.computeIfAbsent(itemstack, s -> 0);
        if (is_mining > 0) {
            IS_MINING.put(itemstack, is_mining - 1);
        }
        double swing_animtime = ((CustomData)itemstack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("swing_animtime");
        double suck_animtime = ((CustomData)itemstack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("suck_animtime");
        if (swing_animtime > 0.0) {
            CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)itemstack, tag -> tag.putDouble("swing_animtime", ((CustomData)itemstack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("swing_animtime") - 1.0));
        }
        if (suck_animtime > 0.0) {
            CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)itemstack, tag -> tag.putDouble("suck_animtime", ((CustomData)itemstack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("suck_animtime") - 1.0));
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public float getDestroySpeed(ItemStack itemstack, BlockState blockstate) {
        IS_MINING.put(itemstack, 5);
        if (((CustomData)itemstack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("swing_animtime") == 0.0 && ((CustomData)itemstack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("suck_animtime") == 0.0) {
            return 1.0f;
        }
        return 0.0f;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player entity, InteractionHand hand) {
        InteractionResultHolder ar = super.use(world, entity, hand);
        ItemStack itemstack = (ItemStack)ar.getObject();
        int is_mining = IS_MINING.computeIfAbsent(itemstack, s -> 0);
        if (is_mining == 0) {
            double swing_animtime = ((CustomData)itemstack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("swing_animtime");
            double suck_animtime = ((CustomData)itemstack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("suck_animtime");
            if (swing_animtime == 0.0 && suck_animtime == 0.0 && itemstack.getDamageValue() > 0) {
                SandwormDartRightclickedProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), (Entity)entity, (ItemStack)ar.getObject());
                CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)itemstack, tag -> tag.putString("itemKey", UUID.randomUUID().toString()));
                CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)itemstack, tag -> tag.putDouble("suck_animtime", 10.0));
            }
        }
        return ar;
    }

    public boolean onEntitySwing(ItemStack itemstack, LivingEntity entity, InteractionHand hand) {
        boolean retval = super.onEntitySwing(itemstack, entity, hand);
        int is_mining = IS_MINING.computeIfAbsent(itemstack, s -> 0);
        if (is_mining == 0) {
            double swing_animtime = ((CustomData)itemstack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("swing_animtime");
            double suck_animtime = ((CustomData)itemstack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("suck_animtime");
            if (swing_animtime == 0.0 && suck_animtime == 0.0 && entity instanceof Player) {
                Player plr = (Player)entity;
                SandwormDartPlayerFinishesUsingItemProcedure.execute((LevelAccessor)entity.level(), entity.getX(), entity.getY(), entity.getZ(), (Entity)entity, itemstack);
                CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)itemstack, tag -> tag.putString("itemKey", UUID.randomUUID().toString()));
                CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)itemstack, tag -> tag.putDouble("swing_animtime", 15.0));
            }
        }
        return retval;
    }

    @SubscribeEvent
    public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem(new IClientItemExtensions(){
            private SandwormDartItemRenderer rendererInstance;

            public HumanoidModel.ArmPose getArmPose(LivingEntity entityLiving, InteractionHand hand, ItemStack itemStack) {
                if (!itemStack.isEmpty() && entityLiving.getUsedItemHand() == hand) {
                    return HumanoidModel.ArmPose.BOW_AND_ARROW;
                }
                return HumanoidModel.ArmPose.EMPTY;
            }

            @OnlyIn(value=Dist.CLIENT)
            public boolean applyForgeHandTransform(PoseStack poseStack, LocalPlayer player, HumanoidArm arm, ItemStack itemInHand, float partialTick, float equipProcess, float swingProcess) {
                int is_mining = IS_MINING.computeIfAbsent(player.getMainHandItem(), s -> 0);
                double swing_animtime = ((CustomData)player.getMainHandItem().getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("swing_animtime");
                double suck_animtime = ((CustomData)player.getMainHandItem().getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("suck_animtime");
                if (is_mining == 0 && (swing_animtime > 0.0 || suck_animtime > 0.0)) {
                    int i = arm == HumanoidArm.RIGHT ? 1 : -1;
                    poseStack.translate((float)i * 0.56f, -0.52f, -0.72f);
                    if (player.getUseItem() == itemInHand) {
                        poseStack.translate(0.05, 0.05, 0.05);
                    }
                    return true;
                }
                return false;
            }

            @OnlyIn(value=Dist.CLIENT)
            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.rendererInstance == null) {
                    this.rendererInstance = new SandwormDartItemRenderer(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
                }
                return this.rendererInstance;
            }
        }, new Item[]{(Item)BlockFactorysBossesModItems.SANDWORM_DART.get()});
    }
}

