/*
 * Decompiled with CFR 0.152.
 */
package net.unusual.blockfactorysbosses.entity;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.unusual.blockfactorysbosses.configuration.ConfigFileConfiguration;
import net.unusual.blockfactorysbosses.entity.DragonMoveControl;
import net.unusual.blockfactorysbosses.entity.NullPrEntity;
import net.unusual.blockfactorysbosses.procedures.DragonFlyConditionProcedure;
import net.unusual.blockfactorysbosses.procedures.DragonGroundConditionProcedure;
import net.unusual.blockfactorysbosses.procedures.InfernalDragonEntityDiesProcedure;
import net.unusual.blockfactorysbosses.procedures.InfernalDragonEntityIsHurtProcedure;
import net.unusual.blockfactorysbosses.procedures.InfernalDragonOnEntityTickUpdateProcedure;

public class InfernalDragonEntity
extends Monster
implements RangedAttackMob {
    public final AnimationState dieAnimationState = new AnimationState();
    public final AnimationState spawnAnimationState = new AnimationState();
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState attackAnimationState = new AnimationState();
    public final AnimationState hitAnimationState = new AnimationState();
    public final AnimationState takeoffAnimationState = new AnimationState();
    public final AnimationState fallAnimationState = new AnimationState();
    public static final EntityDataAccessor<Integer> DATA_spawn_animtime = SynchedEntityData.defineId(InfernalDragonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_attack_cooldown = SynchedEntityData.defineId(InfernalDragonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_attack_animtime = SynchedEntityData.defineId(InfernalDragonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_attack_phase = SynchedEntityData.defineId(InfernalDragonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_boss_phase = SynchedEntityData.defineId(InfernalDragonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_hit_animtime = SynchedEntityData.defineId(InfernalDragonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_fly_animtime = SynchedEntityData.defineId(InfernalDragonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_dive_cooldown = SynchedEntityData.defineId(InfernalDragonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_dive_animtime = SynchedEntityData.defineId(InfernalDragonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_fall_animtime = SynchedEntityData.defineId(InfernalDragonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_battle_time = SynchedEntityData.defineId(InfernalDragonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_die_animtime = SynchedEntityData.defineId(InfernalDragonEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<String> DATA_source_uuid = SynchedEntityData.defineId(InfernalDragonEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);

    public InfernalDragonEntity(EntityType<InfernalDragonEntity> type, Level world) {
        super(type, world);
        this.xpReward = 6250;
        this.setNoAi(false);
        this.setInvisible(true);
        this.setPersistenceRequired();
        this.moveControl = new DragonMoveControl((Mob)this, 10, true);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_spawn_animtime, (Object)0);
        builder.define(DATA_attack_cooldown, (Object)0);
        builder.define(DATA_attack_animtime, (Object)0);
        builder.define(DATA_attack_phase, (Object)0);
        builder.define(DATA_boss_phase, (Object)-1);
        builder.define(DATA_hit_animtime, (Object)0);
        builder.define(DATA_fly_animtime, (Object)55);
        builder.define(DATA_dive_cooldown, (Object)0);
        builder.define(DATA_dive_animtime, (Object)0);
        builder.define(DATA_fall_animtime, (Object)0);
        builder.define(DATA_battle_time, (Object)0);
        builder.define(DATA_die_animtime, (Object)0);
        builder.define(DATA_source_uuid, (Object)"");
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, new Goal(){
            {
                this.setFlags(EnumSet.of(Goal.Flag.MOVE));
            }

            public boolean canUse() {
                if (InfernalDragonEntity.this.getTarget() != null && !InfernalDragonEntity.this.getMoveControl().hasWanted()) {
                    double x = InfernalDragonEntity.this.getX();
                    double y = InfernalDragonEntity.this.getY();
                    double z = InfernalDragonEntity.this.getZ();
                    InfernalDragonEntity entity = InfernalDragonEntity.this;
                    Level world = InfernalDragonEntity.this.level();
                    return DragonFlyConditionProcedure.execute((Entity)entity);
                }
                return false;
            }

            public boolean canContinueToUse() {
                double x = InfernalDragonEntity.this.getX();
                double y = InfernalDragonEntity.this.getY();
                double z = InfernalDragonEntity.this.getZ();
                InfernalDragonEntity entity = InfernalDragonEntity.this;
                Level world = InfernalDragonEntity.this.level();
                return DragonFlyConditionProcedure.execute((Entity)entity) && InfernalDragonEntity.this.getMoveControl().hasWanted() && InfernalDragonEntity.this.getTarget() != null && InfernalDragonEntity.this.getTarget().isAlive();
            }

            public void start() {
                LivingEntity livingentity = InfernalDragonEntity.this.getTarget();
                Vec3 vec3d = livingentity.getEyePosition(1.0f);
                InfernalDragonEntity.this.moveControl.setWantedPosition(vec3d.x, vec3d.y, vec3d.z, 1.0);
            }

            public void tick() {
                LivingEntity livingentity = InfernalDragonEntity.this.getTarget();
                if (InfernalDragonEntity.this.getBoundingBox().intersects(livingentity.getBoundingBox())) {
                    InfernalDragonEntity.this.doHurtTarget((Entity)livingentity);
                } else {
                    double d0 = InfernalDragonEntity.this.distanceToSqr((Entity)livingentity);
                    if (d0 < 16.0) {
                        Vec3 vec3d = livingentity.getEyePosition(1.0f);
                        InfernalDragonEntity.this.moveControl.setWantedPosition(vec3d.x, vec3d.y, vec3d.z, 1.0);
                    }
                }
            }
        });
        this.goalSelector.addGoal(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8, 20){

            protected Vec3 getPosition() {
                RandomSource random = InfernalDragonEntity.this.getRandom();
                double dir_x = InfernalDragonEntity.this.getX() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double dir_y = InfernalDragonEntity.this.getY() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double dir_z = InfernalDragonEntity.this.getZ() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                return new Vec3(dir_x, dir_y, dir_z);
            }

            public boolean canUse() {
                InfernalDragonEntity entity = InfernalDragonEntity.this;
                return super.canUse() && DragonFlyConditionProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                InfernalDragonEntity entity = InfernalDragonEntity.this;
                return super.canContinueToUse() && DragonFlyConditionProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }

            public boolean canUse() {
                InfernalDragonEntity entity = InfernalDragonEntity.this;
                return super.canUse() && DragonGroundConditionProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                InfernalDragonEntity entity = InfernalDragonEntity.this;
                return super.canContinueToUse() && DragonGroundConditionProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]){

            public boolean canUse() {
                InfernalDragonEntity entity = InfernalDragonEntity.this;
                return super.canUse() && DragonGroundConditionProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                InfernalDragonEntity entity = InfernalDragonEntity.this;
                return super.canContinueToUse() && DragonGroundConditionProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8){

            public boolean canUse() {
                InfernalDragonEntity entity = InfernalDragonEntity.this;
                return super.canUse() && DragonGroundConditionProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                InfernalDragonEntity entity = InfernalDragonEntity.this;
                return super.canContinueToUse() && DragonGroundConditionProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                InfernalDragonEntity entity = InfernalDragonEntity.this;
                return super.canUse() && DragonGroundConditionProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                InfernalDragonEntity entity = InfernalDragonEntity.this;
                return super.canContinueToUse() && DragonGroundConditionProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false){

            public boolean canUse() {
                InfernalDragonEntity entity = InfernalDragonEntity.this;
                return super.canUse() && DragonGroundConditionProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                InfernalDragonEntity entity = InfernalDragonEntity.this;
                return super.canContinueToUse() && DragonGroundConditionProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(1, (Goal)new RangedAttackGoal(this, this, 1.25, 20, 3.7f){

            public boolean canContinueToUse() {
                return this.canUse();
            }
        });
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block_factorys_bosses:dragon_footstep")), 0.15f, 1.0f);
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block_factorys_bosses:dragon_hit"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block_factorys_bosses:silence"));
    }

    public boolean causeFallDamage(float l, float d, DamageSource source) {
        return false;
    }

    public void tick() {
        if (this.level().isClientSide) {
            this.dieAnimationState.animateWhen((Integer)this.getEntityData().get(DATA_die_animtime) > 0, this.tickCount);
            this.idleAnimationState.animateWhen(!((Integer)this.getEntityData().get(DATA_die_animtime) != 0 || (Integer)this.getEntityData().get(DATA_spawn_animtime) > 10 && (Integer)this.getEntityData().get(DATA_spawn_animtime) <= 236 || (Integer)this.getEntityData().get(DATA_fall_animtime) != 0 || (Integer)this.getEntityData().get(DATA_fly_animtime) != 0 && (Integer)this.getEntityData().get(DATA_fly_animtime) < 55), this.tickCount);
            this.attackAnimationState.animateWhen((Integer)this.getEntityData().get(DATA_attack_animtime) > 0, this.tickCount);
            this.hitAnimationState.animateWhen((Integer)this.getEntityData().get(DATA_hit_animtime) > 0 && (Integer)this.getEntityData().get(DATA_die_animtime) == 0, this.tickCount);
            this.fallAnimationState.animateWhen((Integer)this.getEntityData().get(DATA_fall_animtime) > 0, this.tickCount);
            this.spawnAnimationState.animateWhen((Integer)this.getEntityData().get(DATA_spawn_animtime) > 10 && (Integer)this.getEntityData().get(DATA_spawn_animtime) <= 236, this.tickCount);
            this.takeoffAnimationState.animateWhen((Integer)this.getEntityData().get(DATA_fly_animtime) > 0 && (Integer)this.getEntityData().get(DATA_fly_animtime) < 55, this.tickCount);
        }
        super.tick();
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        Entity sourceentity = damagesource.getEntity();
        Entity immediatesourceentity = damagesource.getDirectEntity();
        if (damagesource.is(DamageTypes.IN_FIRE)) {
            return false;
        }
        if (damagesource.is(DamageTypes.FALL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.CACTUS)) {
            return false;
        }
        if ((Integer)this.getEntityData().get(DATA_hit_animtime) <= 0 && (Integer)this.getEntityData().get(DATA_spawn_animtime) <= 0) {
            InfernalDragonEntityIsHurtProcedure.execute((LevelAccessor)world, (Entity)this);
            return super.hurt(damagesource, amount);
        }
        return false;
    }

    public void die(DamageSource source) {
        super.die(source);
        InfernalDragonEntityDiesProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this, source.getEntity());
    }

    public boolean fireImmune() {
        return true;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Dataspawn_animtime", ((Integer)this.entityData.get(DATA_spawn_animtime)).intValue());
        compound.putInt("Dataattack_cooldown", ((Integer)this.entityData.get(DATA_attack_cooldown)).intValue());
        compound.putInt("Dataattack_animtime", ((Integer)this.entityData.get(DATA_attack_animtime)).intValue());
        compound.putInt("Dataattack_phase", ((Integer)this.entityData.get(DATA_attack_phase)).intValue());
        compound.putInt("Databoss_phase", ((Integer)this.entityData.get(DATA_boss_phase)).intValue());
        compound.putInt("Datahit_animtime", ((Integer)this.entityData.get(DATA_hit_animtime)).intValue());
        compound.putInt("Datafly_animtime", ((Integer)this.entityData.get(DATA_fly_animtime)).intValue());
        compound.putInt("Datadive_cooldown", ((Integer)this.entityData.get(DATA_dive_cooldown)).intValue());
        compound.putInt("Datadive_animtime", ((Integer)this.entityData.get(DATA_dive_animtime)).intValue());
        compound.putInt("Datafall_animtime", ((Integer)this.entityData.get(DATA_fall_animtime)).intValue());
        compound.putInt("Databattle_time", ((Integer)this.entityData.get(DATA_battle_time)).intValue());
        compound.putInt("Datadie_animtime", ((Integer)this.entityData.get(DATA_die_animtime)).intValue());
        compound.putString("Datasource_uuid", (String)this.entityData.get(DATA_source_uuid));
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Dataspawn_animtime")) {
            this.entityData.set(DATA_spawn_animtime, (Object)compound.getInt("Dataspawn_animtime"));
        }
        if (compound.contains("Dataattack_cooldown")) {
            this.entityData.set(DATA_attack_cooldown, (Object)compound.getInt("Dataattack_cooldown"));
        }
        if (compound.contains("Dataattack_animtime")) {
            this.entityData.set(DATA_attack_animtime, (Object)compound.getInt("Dataattack_animtime"));
        }
        if (compound.contains("Dataattack_phase")) {
            this.entityData.set(DATA_attack_phase, (Object)compound.getInt("Dataattack_phase"));
        }
        if (compound.contains("Databoss_phase")) {
            this.entityData.set(DATA_boss_phase, (Object)compound.getInt("Databoss_phase"));
        }
        if (compound.contains("Datahit_animtime")) {
            this.entityData.set(DATA_hit_animtime, (Object)compound.getInt("Datahit_animtime"));
        }
        if (compound.contains("Datafly_animtime")) {
            this.entityData.set(DATA_fly_animtime, (Object)compound.getInt("Datafly_animtime"));
        }
        if (compound.contains("Datadive_cooldown")) {
            this.entityData.set(DATA_dive_cooldown, (Object)compound.getInt("Datadive_cooldown"));
        }
        if (compound.contains("Datadive_animtime")) {
            this.entityData.set(DATA_dive_animtime, (Object)compound.getInt("Datadive_animtime"));
        }
        if (compound.contains("Datafall_animtime")) {
            this.entityData.set(DATA_fall_animtime, (Object)compound.getInt("Datafall_animtime"));
        }
        if (compound.contains("Databattle_time")) {
            this.entityData.set(DATA_battle_time, (Object)compound.getInt("Databattle_time"));
        }
        if (compound.contains("Datadie_animtime")) {
            this.entityData.set(DATA_die_animtime, (Object)compound.getInt("Datadie_animtime"));
        }
        if (compound.contains("Datasource_uuid")) {
            this.entityData.set(DATA_source_uuid, (Object)compound.getString("Datasource_uuid"));
        }
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(((Double)ConfigFileConfiguration.DRAGON_HEALTH.get()).doubleValue());
        this.getAttribute(Attributes.ARMOR).setBaseValue(((Double)ConfigFileConfiguration.DRAGON_ARMOR.get()).doubleValue());
        InfernalDragonEntity infernalDragonEntity = this;
        if (infernalDragonEntity instanceof LivingEntity) {
            InfernalDragonEntity _entity = infernalDragonEntity;
            _entity.setHealth((float)((Double)ConfigFileConfiguration.DRAGON_HEALTH.get()).doubleValue());
        }
        return retval;
    }

    public void baseTick() {
        super.baseTick();
        if ((Integer)this.getEntityData().get(DATA_boss_phase) != -1 && (Integer)this.getEntityData().get(DATA_boss_phase) != 2) {
            super.setNoGravity(false);
        } else {
            super.setNoGravity(true);
        }
        InfernalDragonOnEntityTickUpdateProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public void performRangedAttack(LivingEntity target, float flval) {
        NullPrEntity.shoot((LivingEntity)this, target);
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void setNoGravity(boolean ignored) {
        super.setNoGravity(true);
    }

    public void aiStep() {
        super.aiStep();
        this.setNoGravity(true);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.4);
        builder = builder.add(Attributes.MAX_HEALTH, 300.0);
        builder = builder.add(Attributes.ARMOR, 25.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 15.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 64.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 1.1);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 0.8);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 0.6);
        builder = builder.add(Attributes.FLYING_SPEED, 1.6);
        return builder;
    }
}

