/*
 * Decompiled with CFR 0.152.
 */
package net.unusual.blockfactorysbosses.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.unusual.blockfactorysbosses.procedures.TallVaseBlockAddedProcedure;
import net.unusual.blockfactorysbosses.procedures.TallVaseBlockDestroyedByPlayerProcedure;
import net.unusual.blockfactorysbosses.procedures.TallVaseBlockValidPlacementConditionProcedure;

public class TallVaseBlock
extends Block {
    public static final IntegerProperty BLOCKSTATE = IntegerProperty.create((String)"blockstate", (int)0, (int)2);

    public TallVaseBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.DECORATED_POT).strength(1.0f, 10.0f).lightLevel(s -> new Object((BlockState)s){
            final /* synthetic */ BlockState val$s;
            {
                this.val$s = blockState;
            }

            public int getLightLevel() {
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 1) {
                    return 0;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 2) {
                    return 0;
                }
                return 0;
            }
        }.getLightLevel()).requiresCorrectToolForDrops().noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if ((Integer)state.getValue((Property)BLOCKSTATE) == 1) {
            return Shapes.or((VoxelShape)TallVaseBlock.box((double)5.0, (double)-16.0, (double)5.0, (double)11.0, (double)-14.0, (double)11.0), (VoxelShape[])new VoxelShape[]{TallVaseBlock.box((double)3.0, (double)-14.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0), TallVaseBlock.box((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)11.0, (double)10.0), TallVaseBlock.box((double)5.0, (double)11.0, (double)5.0, (double)11.0, (double)13.0, (double)11.0)});
        }
        if ((Integer)state.getValue((Property)BLOCKSTATE) == 2) {
            return Shapes.or((VoxelShape)TallVaseBlock.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)2.0, (double)11.0), (VoxelShape[])new VoxelShape[]{TallVaseBlock.box((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)22.0, (double)13.0), TallVaseBlock.box((double)6.0, (double)22.0, (double)6.0, (double)10.0, (double)27.0, (double)10.0), TallVaseBlock.box((double)5.0, (double)27.0, (double)5.0, (double)11.0, (double)29.0, (double)11.0)});
        }
        return Shapes.or((VoxelShape)TallVaseBlock.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)2.0, (double)11.0), (VoxelShape[])new VoxelShape[]{TallVaseBlock.box((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)22.0, (double)13.0), TallVaseBlock.box((double)6.0, (double)22.0, (double)6.0, (double)10.0, (double)27.0, (double)10.0), TallVaseBlock.box((double)5.0, (double)27.0, (double)5.0, (double)11.0, (double)29.0, (double)11.0)});
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BLOCKSTATE});
    }

    public boolean canSurvive(BlockState blockstate, LevelReader worldIn, BlockPos pos) {
        if (worldIn instanceof LevelAccessor) {
            LevelAccessor world = (LevelAccessor)worldIn;
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            return TallVaseBlockValidPlacementConditionProcedure.execute(world, x, y, z, blockstate);
        }
        return super.canSurvive(blockstate, worldIn, pos);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        return !state.canSurvive((LevelReader)world, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, facing, facingState, world, currentPos, facingPos);
    }

    public void onPlace(BlockState blockstate, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        super.onPlace(blockstate, world, pos, oldState, moving);
        TallVaseBlockAddedProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ(), blockstate);
    }

    public boolean onDestroyedByPlayer(BlockState blockstate, Level world, BlockPos pos, Player entity, boolean willHarvest, FluidState fluid) {
        boolean retval = super.onDestroyedByPlayer(blockstate, world, pos, entity, willHarvest, fluid);
        TallVaseBlockDestroyedByPlayerProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ(), (Entity)entity);
        return retval;
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState blockstate, LivingEntity entity, ItemStack itemstack) {
        super.setPlacedBy(world, pos, blockstate, entity, itemstack);
        TallVaseBlockAddedProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ(), blockstate);
    }
}

