/*
 * Decompiled with CFR 0.152.
 */
package net.Pandarix.block.custom;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Map;
import net.Pandarix.block.custom.ArchelogyTable;
import net.Pandarix.block.custom.FossilBaseWithEntityBlock;
import net.Pandarix.block.entity.VillagerFossilBlockEntity;
import net.Pandarix.util.ServerPlayerHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VillagerFossilBlock
extends FossilBaseWithEntityBlock {
    public static final MapCodec<ArchelogyTable> CODEC = VillagerFossilBlock.simpleCodec(ArchelogyTable::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final IntegerProperty INVENTORY_LUMINANCE = IntegerProperty.create((String)"inventory_luminance", (int)0, (int)15);
    private static final Map<Direction, VoxelShape> VILLAGER_SHAPES_FOR_DIRECTION = ImmutableMap.of((Object)Direction.NORTH, (Object)Shapes.or((VoxelShape)Block.box((double)4.75, (double)0.0, (double)9.0, (double)11.0, (double)10.0, (double)12.0), (VoxelShape[])new VoxelShape[]{Block.box((double)4.0, (double)10.0, (double)7.0, (double)12.0, (double)20.0, (double)12.5), Block.box((double)3.0, (double)20.0, (double)2.0, (double)11.0, (double)29.0, (double)7.5)}), (Object)Direction.SOUTH, (Object)Shapes.or((VoxelShape)Block.box((double)5.0, (double)0.0, (double)4.0, (double)11.25, (double)10.0, (double)7.0), (VoxelShape[])new VoxelShape[]{Block.box((double)4.0, (double)10.0, (double)3.5, (double)12.0, (double)20.0, (double)9.0), Block.box((double)5.0, (double)20.0, (double)8.5, (double)13.0, (double)29.0, (double)14.0)}), (Object)Direction.EAST, (Object)Shapes.or((VoxelShape)Block.box((double)4.0, (double)0.0, (double)4.75, (double)7.0, (double)10.0, (double)11.0), (VoxelShape[])new VoxelShape[]{Block.box((double)3.5, (double)10.0, (double)4.0, (double)9.0, (double)20.0, (double)12.0), Block.box((double)8.5, (double)20.0, (double)3.0, (double)14.0, (double)29.0, (double)11.0)}), (Object)Direction.WEST, (Object)Shapes.or((VoxelShape)Block.box((double)9.0, (double)0.0, (double)5.0, (double)12.0, (double)10.0, (double)11.25), (VoxelShape[])new VoxelShape[]{Block.box((double)7.0, (double)10.0, (double)4.0, (double)12.5, (double)20.0, (double)12.0), Block.box((double)2.0, (double)20.0, (double)5.0, (double)7.5, (double)29.0, (double)13.0)}));

    @Override
    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public VillagerFossilBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)INVENTORY_LUMINANCE, (Comparable)Integer.valueOf(0)));
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        BlockEntity blockEntity;
        if (pState.getBlock() != pNewState.getBlock() && (blockEntity = pLevel.getBlockEntity(pPos)) instanceof VillagerFossilBlockEntity) {
            VillagerFossilBlockEntity villagerFossilBlockEntity = (VillagerFossilBlockEntity)blockEntity;
            Containers.dropContents((Level)pLevel, (BlockPos)pPos, (Container)villagerFossilBlockEntity);
            pLevel.updateNeighbourForOutputSignal(pPos, (Block)this);
        }
        super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    @NotNull
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return VILLAGER_SHAPES_FOR_DIRECTION.get(pState.getValue((Property)FACING));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{INVENTORY_LUMINANCE});
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new VillagerFossilBlockEntity(pos, state);
    }

    @NotNull
    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Override
    @NotNull
    public InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHitResult) {
        if (!pLevel.isClientSide()) {
            BlockEntity entity = pLevel.getBlockEntity(pPos);
            if (entity instanceof VillagerFossilBlockEntity) {
                ServerPlayerHelper.tryOpenScreen(pPlayer, (VillagerFossilBlockEntity)entity);
            } else {
                throw new IllegalStateException("VillagerFossilBlockEntity Container provider is missing!");
            }
        }
        return InteractionResult.sidedSuccess((boolean)pLevel.isClientSide());
    }

    public void appendHoverText(@NotNull ItemStack stack, Item.TooltipContext pContext, List<Component> component, @NotNull TooltipFlag flag) {
        component.add((Component)Component.translatable((String)"block.betterarcheology.villager_fossil_tooltip").withStyle(ChatFormatting.GRAY));
        super.appendHoverText(stack, pContext, component, flag);
    }
}

