/*
 * Decompiled with CFR 0.152.
 */
package net.Pandarix.block.custom;

import java.util.Optional;
import net.Pandarix.BACommon;
import net.Pandarix.util.ServerPlayerHelper;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LootVaseBlock
extends Block {
    private static final VoxelShape SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0);
    ResourceLocation ADVANCEMENT_ID = BACommon.createResource("loot_vase_broken");

    public LootVaseBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public void playerDestroy(Level level, Player player, BlockPos blockPos, BlockState blockState, @Nullable BlockEntity blockEntity, ItemStack itemStack) {
        try {
            boolean hasSilkTouch;
            Optional SILK_TOUCH = level.registryAccess().asGetterLookup().lookupOrThrow(Registries.ENCHANTMENT).get(Enchantments.SILK_TOUCH);
            boolean bl = hasSilkTouch = SILK_TOUCH.isPresent() && EnchantmentHelper.getItemEnchantmentLevel((Holder)((Holder)SILK_TOUCH.get()), (ItemStack)player.getMainHandItem()) > 0;
            if (!level.isClientSide()) {
                AdvancementHolder advancement;
                if (!player.isCreative() && !hasSilkTouch) {
                    ExperienceOrb xpOrb = new ExperienceOrb(level, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), 4);
                    level.addFreshEntity((Entity)xpOrb);
                }
                if (level.getServer() != null && (advancement = level.getServer().getAdvancements().get(this.ADVANCEMENT_ID)) != null) {
                    ServerPlayerHelper.tryGetServerPlayer(player).ifPresent(sp -> sp.getAdvancements().award(advancement, "criteria"));
                }
            }
            if (level.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS) && !hasSilkTouch && level.getRandom().nextInt(25) == 1) {
                LootVaseBlock.spawnSilverFish(level, blockPos);
            }
        }
        catch (Exception e) {
            BACommon.LOGGER.error("Error in breaking LootVase Block! : ", (Throwable)e);
        }
        super.playerDestroy(level, player, blockPos, blockState, blockEntity, itemStack);
    }

    private static void spawnSilverFish(Level level, BlockPos pos) {
        Silverfish silverfishEntity = (Silverfish)EntityType.SILVERFISH.create(level);
        if (silverfishEntity != null) {
            silverfishEntity.moveTo((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, 0.0f, 0.0f);
            level.addFreshEntity((Entity)silverfishEntity);
            silverfishEntity.spawnAnim();
        }
    }

    @NotNull
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    protected boolean isPathfindable(BlockState blockState, PathComputationType pathComputationType) {
        return false;
    }
}

