/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.payloads;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.lucene.ars_nouveau.index.PostingsEnum;
import org.apache.lucene.ars_nouveau.index.Term;
import org.apache.lucene.ars_nouveau.queries.spans.SpanCollector;
import org.apache.lucene.ars_nouveau.util.BytesRef;

public class PayloadSpanCollector
implements SpanCollector {
    private final Collection<byte[]> payloads = new ArrayList<byte[]>();

    @Override
    public void collectLeaf(PostingsEnum postings, int position, Term term) throws IOException {
        BytesRef payload = postings.getPayload();
        if (payload == null) {
            return;
        }
        byte[] bytes = new byte[payload.length];
        System.arraycopy(payload.bytes, payload.offset, bytes, 0, payload.length);
        this.payloads.add(bytes);
    }

    @Override
    public void reset() {
        this.payloads.clear();
    }

    public Collection<byte[]> getPayloads() {
        return this.payloads;
    }
}

