/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.analysis.miscellaneous;

import java.util.Map;
import org.apache.lucene.ars_nouveau.analysis.TokenFilterFactory;
import org.apache.lucene.ars_nouveau.analysis.TokenStream;
import org.apache.lucene.ars_nouveau.analysis.miscellaneous.ASCIIFoldingFilter;

public class ASCIIFoldingFilterFactory
extends TokenFilterFactory {
    public static final String NAME = "asciiFolding";
    private static final String PRESERVE_ORIGINAL = "preserveOriginal";
    private final boolean preserveOriginal;

    public ASCIIFoldingFilterFactory(Map<String, String> args) {
        super(args);
        this.preserveOriginal = this.getBoolean(args, PRESERVE_ORIGINAL, false);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + String.valueOf(args));
        }
    }

    public ASCIIFoldingFilterFactory() {
        throw ASCIIFoldingFilterFactory.defaultCtorException();
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new ASCIIFoldingFilter(input, this.preserveOriginal);
    }

    @Override
    public TokenStream normalize(TokenStream input) {
        return new ASCIIFoldingFilter(input, false);
    }
}

