/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.event.EventQueue;
import com.hollingsworth.arsnouveau.api.event.ParticleTimelineEvent;
import com.hollingsworth.arsnouveau.api.particle.ParticleEmitter;
import com.hollingsworth.arsnouveau.common.network.AbstractPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class PacketPrestidigitation
extends AbstractPacket {
    int entityId;
    int ticks;
    ParticleEmitter emitter;
    public static final CustomPacketPayload.Type<PacketPrestidigitation> TYPE = new CustomPacketPayload.Type(ArsNouveau.prefix("prestidigitation"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketPrestidigitation> CODEC = StreamCodec.ofMember(PacketPrestidigitation::toBytes, PacketPrestidigitation::new);

    public PacketPrestidigitation(Entity entity, int ticks, ParticleEmitter emitter) {
        this.entityId = entity.getId();
        this.ticks = ticks;
        this.emitter = emitter;
    }

    public PacketPrestidigitation(RegistryFriendlyByteBuf pb) {
        this.entityId = pb.readVarInt();
        this.ticks = pb.readVarInt();
        this.emitter = (ParticleEmitter)ParticleEmitter.STREAM.decode((Object)pb);
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf pb) {
        pb.writeVarInt(this.entityId);
        pb.writeVarInt(this.ticks);
        ParticleEmitter.STREAM.encode((Object)pb, (Object)this.emitter);
    }

    @Override
    public void onClientReceived(Minecraft minecraft, Player player) {
        Entity entity = player.level.getEntity(this.entityId);
        if (entity instanceof Entity) {
            Entity entity2 = entity;
            this.emitter.position = () -> entity2.getBoundingBox().getCenter();
            EventQueue.getClientQueue().addEvent(new ParticleTimelineEvent(player.level, this.emitter, this.ticks));
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

