/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.pathfinding;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.BambooSaplingBlock;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.MagmaBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.VoxelShape;

public enum SurfaceType {
    WALKABLE,
    DROPABLE,
    NOT_PASSABLE;


    public static SurfaceType getSurfaceType(BlockGetter world, BlockState blockState, BlockPos pos) {
        Block block = blockState.getBlock();
        if (block instanceof FenceBlock || block instanceof FenceGateBlock || block instanceof WallBlock || block instanceof FireBlock || block instanceof CampfireBlock || block instanceof BarrelBlock || block instanceof BambooSaplingBlock || block instanceof DoorBlock || block instanceof MagmaBlock) {
            return NOT_PASSABLE;
        }
        VoxelShape shape = blockState.getShape(world, pos);
        if (shape.max(Direction.Axis.Y) > 1.0) {
            return NOT_PASSABLE;
        }
        FluidState fluid = world.getFluidState(pos);
        if (blockState.getBlock() == Blocks.LAVA || fluid != null && !fluid.isEmpty() && (fluid.getType() == Fluids.LAVA || fluid.getType() == Fluids.FLOWING_LAVA)) {
            return NOT_PASSABLE;
        }
        if (SurfaceType.isWater(world, pos, blockState, fluid)) {
            return WALKABLE;
        }
        if (block instanceof SignBlock || block instanceof VineBlock) {
            return DROPABLE;
        }
        if (blockState.isSolid() && shape.max(Direction.Axis.X) - shape.min(Direction.Axis.X) > 0.75 && shape.max(Direction.Axis.Z) - shape.min(Direction.Axis.Z) > 0.75 || blockState.getBlock() == Blocks.SNOW && (Integer)blockState.getValue((Property)SnowLayerBlock.LAYERS) > 1 || block instanceof CarpetBlock) {
            return WALKABLE;
        }
        return DROPABLE;
    }

    public static boolean isWater(BlockGetter world, BlockPos pos) {
        return SurfaceType.isWater(world, pos, null, null);
    }

    public static boolean isWater(BlockGetter world, BlockPos pos, BlockState pState, FluidState pFluidState) {
        BlockState state = pState;
        if (state == null) {
            state = world.getBlockState(pos);
        }
        if (state.canOcclude()) {
            return false;
        }
        if (state.getBlock() == Blocks.WATER) {
            return true;
        }
        FluidState fluidState = pFluidState;
        if (fluidState == null) {
            fluidState = world.getFluidState(pos);
        }
        if (fluidState == null || fluidState.isEmpty()) {
            return false;
        }
        Fluid fluid = fluidState.getType();
        return fluid == Fluids.WATER || fluid == Fluids.FLOWING_WATER;
    }
}

