/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.api.particle.ParticleEmitter;
import com.hollingsworth.arsnouveau.api.particle.timelines.IParticleTimelineType;
import com.hollingsworth.arsnouveau.api.particle.timelines.ProjectileTimeline;
import com.hollingsworth.arsnouveau.api.particle.timelines.TimelineEntryData;
import com.hollingsworth.arsnouveau.api.particle.timelines.TimelineMap;
import com.hollingsworth.arsnouveau.api.registry.ParticleTimelineRegistry;
import com.hollingsworth.arsnouveau.api.sound.ConfiguredSpellSound;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.common.util.ANCodecs;
import com.hollingsworth.arsnouveau.setup.registry.DataSerializers;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class EntitySpellArrow
extends Arrow {
    public int pierceLeft;
    BlockPos lastPosHit;
    Entity lastEntityHit;
    public static final EntityDataAccessor<SpellResolver> SPELL_RESOLVER = SynchedEntityData.defineId(EntitySpellArrow.class, (EntityDataSerializer)((EntityDataSerializer)DataSerializers.SPELL_RESOLVER.get()));
    public ParticleEmitter tickEmitter;
    public ParticleEmitter resolveEmitter;
    public ParticleEmitter onSpawnEmitter;
    public ParticleEmitter flairEmitter;
    public ConfiguredSpellSound castSound;
    public ConfiguredSpellSound resolveSound;
    protected boolean playedSpawnParticle;

    public EntitySpellArrow(EntityType<? extends Arrow> type, Level worldIn) {
        super(type, worldIn);
    }

    public EntitySpellArrow(Level worldIn, double x, double y, double z, ItemStack pPickupItemStack, @Nullable ItemStack p_345233_) {
        super(worldIn, x, y, z, pPickupItemStack, p_345233_);
    }

    public EntitySpellArrow(Level worldIn, LivingEntity shooter, ItemStack pPickupItemStack, @Nullable ItemStack weaponStack) {
        super(worldIn, shooter, pPickupItemStack, weaponStack);
    }

    public SpellResolver resolver() {
        return (SpellResolver)this.entityData.get(SPELL_RESOLVER);
    }

    public void setResolver(SpellResolver resolver) {
        if (resolver.spellContext != null) {
            resolver.spellContext.level = this.level;
        }
        this.entityData.set(SPELL_RESOLVER, (Object)resolver);
        this.buildEmitters();
    }

    public void buildEmitters() {
        TimelineMap timelineMap = this.resolver().spell.particleTimeline();
        ProjectileTimeline projectileTimeline = (ProjectileTimeline)timelineMap.get((IParticleTimelineType)ParticleTimelineRegistry.PROJECTILE_TIMELINE.get());
        TimelineEntryData trailConfig = projectileTimeline.trailEffect;
        TimelineEntryData resolveConfig = projectileTimeline.onResolvingEffect;
        TimelineEntryData spawnConfig = projectileTimeline.onSpawnEffect;
        TimelineEntryData flairConfig = projectileTimeline.flairEffect;
        this.tickEmitter = new ParticleEmitter(() -> this.getPosition(ClientInfo.partialTicks), () -> ((EntitySpellArrow)this).getRotationVector(), trailConfig);
        this.resolveEmitter = new ParticleEmitter(() -> this.getPosition(ClientInfo.partialTicks), () -> ((EntitySpellArrow)this).getRotationVector(), resolveConfig);
        this.onSpawnEmitter = new ParticleEmitter(() -> this.getPosition(ClientInfo.partialTicks), () -> ((EntitySpellArrow)this).getRotationVector(), spawnConfig);
        this.flairEmitter = new ParticleEmitter(() -> this.getPosition(ClientInfo.partialTicks), () -> ((EntitySpellArrow)this).getRotationVector(), flairConfig);
        Vec3 center = this.getDimensions(this.getPose()).makeBoundingBox(0.0, 0.0, 0.0).getCenter();
        this.tickEmitter.setPositionOffset(center);
        this.resolveEmitter.setPositionOffset(center);
        this.onSpawnEmitter.setPositionOffset(center);
        this.flairEmitter.setPositionOffset(center);
        this.castSound = projectileTimeline.castSound.sound;
        this.resolveSound = projectileTimeline.resolveSound.sound;
    }

    public void playParticles() {
        if (this.tickEmitter == null && this.resolver() != null) {
            this.buildEmitters();
        }
        if (this.tickEmitter != null) {
            this.tickEmitter.tick(this.level);
        }
        if (this.flairEmitter != null) {
            this.flairEmitter.tick(this.level);
        }
        if (!this.playedSpawnParticle && this.onSpawnEmitter != null) {
            this.onSpawnEmitter.tick(this.level);
            this.playedSpawnParticle = true;
        }
    }

    public void tick() {
        Vec3 vector3d3;
        boolean isNoClip = this.isNoPhysics();
        Vec3 vector3d = this.getDeltaMovement();
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            float f = Mth.sqrt((float)((float)vector3d.horizontalDistanceSqr()));
            this.yRot = (float)(Mth.atan2((double)vector3d.x, (double)vector3d.z) * 57.2957763671875);
            this.xRot = (float)(Mth.atan2((double)vector3d.y, (double)f) * 57.2957763671875);
            this.yRotO = this.yRot;
            this.xRotO = this.xRot;
        }
        if (this.shakeTime > 0) {
            --this.shakeTime;
        }
        if (this.isInWaterOrRain()) {
            this.clearFire();
        }
        this.inGroundTime = 0;
        Vec3 vector3d2 = this.position();
        BlockHitResult raytraceresult = this.level.clip(new ClipContext(vector3d2, vector3d3 = vector3d2.add(vector3d), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        if (raytraceresult.getType() != HitResult.Type.MISS) {
            vector3d3 = raytraceresult.getLocation();
        }
        while (!this.isRemoved()) {
            EntityHitResult entityraytraceresult = this.findHitEntity(vector3d2, vector3d3);
            if (entityraytraceresult != null) {
                raytraceresult = entityraytraceresult;
            }
            if (raytraceresult instanceof EntityHitResult) {
                EntityHitResult entityHitResult = (EntityHitResult)raytraceresult;
                Entity entity = entityHitResult.getEntity();
                Entity entity1 = this.getOwner();
                if (entity.noPhysics) {
                    raytraceresult = null;
                    entityraytraceresult = null;
                } else if (entity instanceof Player) {
                    Player player2;
                    Player player1 = (Player)entity;
                    if (entity1 instanceof Player && !(player2 = (Player)entity1).canHarmPlayer(player1)) {
                        raytraceresult = null;
                        entityraytraceresult = null;
                    }
                }
            }
            if (raytraceresult != null && raytraceresult.getType() != HitResult.Type.MISS && !isNoClip && !EventHooks.onProjectileImpact((Projectile)this, (HitResult)raytraceresult)) {
                this.onHit((HitResult)raytraceresult);
                this.hasImpulse = true;
            }
            if (entityraytraceresult == null || this.getPierceLevel() <= 0) break;
            raytraceresult = null;
        }
        vector3d = this.getDeltaMovement();
        double d3 = vector3d.x;
        double d4 = vector3d.y;
        double d0 = vector3d.z;
        if (this.isCritArrow()) {
            for (int i = 0; i < 4; ++i) {
                this.level.addParticle((ParticleOptions)ParticleTypes.CRIT, this.getX() + d3 * (double)i / 4.0, this.getY() + d4 * (double)i / 4.0, this.getZ() + d0 * (double)i / 4.0, -d3, -d4 + 0.2, -d0);
            }
        }
        double d5 = this.getX() + d3;
        double d1 = this.getY() + d4;
        double d2 = this.getZ() + d0;
        float f1 = Mth.sqrt((float)((float)vector3d.horizontalDistanceSqr()));
        this.yRot = isNoClip ? (float)(Mth.atan2((double)(-d3), (double)(-d0)) * 57.2957763671875) : (float)(Mth.atan2((double)d3, (double)d0) * 57.2957763671875);
        this.xRot = (float)(Mth.atan2((double)d4, (double)f1) * 57.2957763671875);
        this.xRot = EntitySpellArrow.lerpRotation((float)this.xRotO, (float)this.xRot);
        this.yRot = EntitySpellArrow.lerpRotation((float)this.yRotO, (float)this.yRot);
        float f2 = 0.99f;
        if (this.isInWater()) {
            for (int j = 0; j < 4; ++j) {
                this.level.addParticle((ParticleOptions)ParticleTypes.BUBBLE, d5 - d3 * 0.25, d1 - d4 * 0.25, d2 - d0 * 0.25, d3, d4, d0);
            }
            f2 = this.getWaterInertia();
        }
        this.setDeltaMovement(vector3d.scale((double)f2));
        if (!this.isNoGravity() && !isNoClip) {
            Vec3 vector3d4 = this.getDeltaMovement();
            this.setDeltaMovement(vector3d4.x, vector3d4.y - (double)0.05f, vector3d4.z);
        }
        this.setPos(d5, d1, d2);
        this.checkInsideBlocks();
        if (this.level.isClientSide) {
            this.playParticles();
        }
        if (!this.level.isClientSide && this.tickCount == 1 && this.castSound != null) {
            this.castSound.playSound(this.level, this.position);
        }
    }

    protected void attemptRemoval() {
        if (this.level.isClientSide) {
            return;
        }
        --this.pierceLeft;
        if (this.pierceLeft < 0) {
            this.level.broadcastEntityEvent((Entity)this, (byte)3);
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    public byte getPierceLevel() {
        return 12;
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("resolver")) {
            this.setResolver((SpellResolver)ANCodecs.decode(SpellResolver.CODEC.codec(), tag.get("resolver")));
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        if (this.resolver() != null) {
            tag.put("resolver", ANCodecs.encode(SpellResolver.CODEC.codec(), this.resolver()));
        }
    }

    protected void onHitEntity(EntityHitResult p_213868_1_) {
        super.onHitEntity(p_213868_1_);
        Entity entity = p_213868_1_.getEntity();
        float f = (float)this.getDeltaMovement().length();
        double d0 = this.getBaseDamage();
        Entity entity1 = this.getOwner();
        DamageSource damagesource = this.damageSources().arrow((AbstractArrow)this, (Entity)(entity1 != null ? entity1 : this));
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            d0 = EnchantmentHelper.modifyDamage((ServerLevel)serverlevel, (ItemStack)this.getWeaponItem(), (Entity)entity, (DamageSource)damagesource, (float)((float)d0));
        }
        int j = Mth.ceil((double)Mth.clamp((double)((double)f * d0), (double)0.0, (double)2.147483647E9));
        if (this.isCritArrow()) {
            long k = this.random.nextInt(j / 2 + 2);
            j = (int)Math.min(k + (long)j, Integer.MAX_VALUE);
        }
        if (entity1 instanceof LivingEntity) {
            LivingEntity livingentity1 = (LivingEntity)entity1;
            livingentity1.setLastHurtMob(entity);
        }
        boolean flag = entity.getType() == EntityType.ENDERMAN;
        int i = entity.getRemainingFireTicks();
        if (this.isOnFire() && !flag) {
            entity.igniteForSeconds(5.0f);
        }
        if (entity.hurt(damagesource, (float)j)) {
            if (flag) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                if (!this.level().isClientSide && this.getPierceLevel() <= 0) {
                    livingentity.setArrowCount(livingentity.getArrowCount() + 1);
                }
                this.doKnockback(livingentity, damagesource);
                Level level2 = this.level();
                if (level2 instanceof ServerLevel) {
                    ServerLevel serverlevel1 = (ServerLevel)level2;
                    EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverlevel1, (Entity)livingentity, (DamageSource)damagesource, (ItemStack)this.getWeaponItem());
                }
                this.doPostHurtEffects(livingentity);
            }
        } else {
            entity.setRemainingFireTicks(i);
            this.deflect(ProjectileDeflection.REVERSE, entity, this.getOwner(), false);
            this.setDeltaMovement(this.getDeltaMovement().scale(0.2));
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(SPELL_RESOLVER, (Object)new SpellResolver(new SpellContext(this.level, new Spell(), null, null)));
    }

    protected void doPostHurtEffects(LivingEntity living) {
        super.doPostHurtEffects(living);
        this.playResolve();
    }

    protected void onHit(HitResult result) {
        HitResult.Type raytraceresult$type;
        if (this.resolver() != null) {
            this.resolver().onResolveEffect(this.level, result);
        }
        if ((raytraceresult$type = result.getType()) == HitResult.Type.ENTITY) {
            if (this.resolver() != null) {
                this.resolver().onResolveEffect(this.level, result);
            }
            this.onHitEntity((EntityHitResult)result);
            this.attemptRemoval();
            this.lastEntityHit = ((EntityHitResult)result).getEntity();
        } else if (raytraceresult$type == HitResult.Type.BLOCK && !((BlockHitResult)result).getBlockPos().equals((Object)this.lastPosHit)) {
            if (this.resolver() != null) {
                this.resolver().onResolveEffect(this.level, result);
            }
            this.onHitBlock((BlockHitResult)result);
            this.lastPosHit = ((BlockHitResult)result).getBlockPos();
            this.attemptRemoval();
        }
    }

    protected void onHitBlock(BlockHitResult p_230299_1_) {
        BlockState blockstate = this.level.getBlockState(p_230299_1_.getBlockPos());
        blockstate.onProjectileHit(this.level, blockstate, p_230299_1_, (Projectile)this);
        this.playResolve();
    }

    public void playResolve() {
        this.playSound(this.getDefaultHitGroundSoundEvent(), 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
        if (this.resolveEmitter != null) {
            this.resolveEmitter.tick(this.level);
        }
    }

    protected SoundEvent getDefaultHitGroundSoundEvent() {
        if (this.resolveSound != null) {
            return (SoundEvent)this.resolveSound.getSound().getSoundEvent().value();
        }
        return super.getDefaultHitGroundSoundEvent();
    }

    public EntityType<?> getType() {
        return (EntityType)ModEntities.ENTITY_SPELL_ARROW.get();
    }
}

