/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.capability;

import com.hollingsworth.arsnouveau.api.mana.IManaCap;
import com.hollingsworth.arsnouveau.common.capability.ManaData;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketUpdateMana;
import com.hollingsworth.arsnouveau.setup.registry.AttachmentsRegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;

public class ManaCap
implements IManaCap {
    private ManaData manaData;
    LivingEntity entity;

    public ManaCap(LivingEntity livingEntity) {
        this.manaData = (ManaData)livingEntity.getData(AttachmentsRegistry.MANA_ATTACHMENT);
        this.entity = livingEntity;
    }

    @Override
    public double getCurrentMana() {
        return this.manaData.getMana();
    }

    @Override
    public int getMaxMana() {
        return this.manaData.getMaxMana();
    }

    @Override
    public void setMaxMana(int maxMana) {
        this.manaData.setMaxMana(maxMana);
        this.entity.setData(AttachmentsRegistry.MANA_ATTACHMENT, (Object)this.manaData);
    }

    @Override
    public double setMana(double mana) {
        if (mana > (double)this.getMaxMana()) {
            this.manaData.setMana(this.getMaxMana());
        } else if (mana < 0.0) {
            this.manaData.setMana(0.0);
        } else {
            this.manaData.setMana(mana);
        }
        this.entity.setData(AttachmentsRegistry.MANA_ATTACHMENT, (Object)this.manaData);
        return this.getCurrentMana();
    }

    @Override
    public double addMana(double manaToAdd) {
        this.setMana(this.getCurrentMana() + manaToAdd);
        return this.getCurrentMana();
    }

    @Override
    public double removeMana(double manaToRemove) {
        if (manaToRemove < 0.0) {
            manaToRemove = 0.0;
        }
        this.setMana(this.getCurrentMana() - manaToRemove);
        return this.getCurrentMana();
    }

    @Override
    public int getGlyphBonus() {
        return this.manaData.getGlyphBonus();
    }

    @Override
    public void setGlyphBonus(int glyphBonus) {
        this.manaData.setGlyphBonus(glyphBonus);
        this.entity.setData(AttachmentsRegistry.MANA_ATTACHMENT, (Object)this.manaData);
    }

    @Override
    public int getBookTier() {
        return this.manaData.getBookTier();
    }

    @Override
    public void setBookTier(int bookTier) {
        this.manaData.setBookTier(bookTier);
        this.entity.setData(AttachmentsRegistry.MANA_ATTACHMENT, (Object)this.manaData);
    }

    public float getReserve() {
        return this.manaData.getReservedMana();
    }

    public void setReserve(float reserve) {
        this.manaData.setReservedMana(reserve);
        this.entity.setData(AttachmentsRegistry.MANA_ATTACHMENT, (Object)this.manaData);
    }

    public void setManaData(ManaData manaData) {
        this.manaData = manaData;
    }

    public void syncToClient(ServerPlayer player) {
        CompoundTag tag = this.manaData.serializeNBT((HolderLookup.Provider)player.registryAccess());
        Networking.sendToPlayerClient(new PacketUpdateMana(tag), player);
    }
}

