/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.jei;

import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.phys.Vec2;

public abstract class MultiInputCategory<T>
implements IRecipeCategory<T> {
    protected Function<T, MultiProvider> multiProvider;
    protected Vec2 point = new Vec2(48.0f, 13.0f);
    protected Vec2 center = new Vec2(48.0f, 45.0f);

    public MultiInputCategory(IGuiHelper helper, Function<T, MultiProvider> multiProvider) {
        this.multiProvider = multiProvider;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup focuses) {
        MultiProvider provider = this.multiProvider.apply(recipe);
        List<Ingredient> inputs = provider.input;
        double angleBetweenEach = 360.0 / (double)inputs.size();
        if (provider.optionalCenter != null) {
            builder.addSlot(RecipeIngredientRole.INPUT, 48, 45).addIngredients(provider.optionalCenter);
        }
        for (Ingredient input : inputs) {
            builder.addSlot(RecipeIngredientRole.INPUT, (int)this.point.x, (int)this.point.y).addIngredients(input);
            this.point = MultiInputCategory.rotatePointAbout(this.point, this.center, angleBetweenEach);
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 86, 10).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)provider.output);
    }

    public static Vec2 rotatePointAbout(Vec2 in, Vec2 about, double degrees) {
        double rad = degrees * Math.PI / 180.0;
        double newX = Math.cos(rad) * (double)(in.x - about.x) - Math.sin(rad) * (double)(in.y - about.y) + (double)about.x;
        double newY = Math.sin(rad) * (double)(in.x - about.x) + Math.cos(rad) * (double)(in.y - about.y) + (double)about.y;
        return new Vec2((float)newX, (float)newY);
    }

    public record MultiProvider(ItemStack output, List<Ingredient> input, @Nullable Ingredient optionalCenter) {
    }
}

