/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui.book;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.documentation.DocAssets;
import com.hollingsworth.arsnouveau.api.spell.SpellValidationError;
import com.hollingsworth.arsnouveau.client.gui.BookSlider;
import com.hollingsworth.arsnouveau.client.gui.GuiUtils;
import com.hollingsworth.arsnouveau.client.gui.buttons.ANButton;
import com.hollingsworth.arsnouveau.client.gui.buttons.SaveButton;
import com.hollingsworth.nuggets.client.gui.BaseScreen;
import com.hollingsworth.nuggets.client.gui.ITooltipRenderer;
import com.hollingsworth.nuggets.client.gui.NuggetImageButton;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class BaseBook
extends BaseScreen {
    public static final int FONT_COLOR = -8355712;
    public static final int FULL_WIDTH = 290;
    public static final int FULL_HEIGHT = 188;
    public static final int LEFT_PAGE_OFFSET = 19;
    public static final int RIGHT_PAGE_OFFSET = 153;
    public static final int PAGE_TOP_OFFSET = 17;
    public static final int ONE_PAGE_WIDTH = 118;
    public static final int ONE_PAGE_HEIGHT = 146;
    public static ResourceLocation background = ArsNouveau.prefix("textures/gui/spell_book_template.png");
    public int bookLeft;
    public int bookTop;
    public int bookRight;
    public int bookBottom;
    public List<SpellValidationError> validationErrors = new ArrayList<SpellValidationError>();
    public SaveButton saveButton;
    public static BaseBook lastOpenedScreen = null;

    public BaseBook() {
        super((Component)Component.literal((String)""), DocAssets.BACKGROUND.width(), DocAssets.BACKGROUND.height(), DocAssets.BACKGROUND.location());
    }

    public void init() {
        super.init();
        lastOpenedScreen = this;
        this.bookLeft = this.width / 2 - 145;
        this.bookTop = this.height / 2 - 94;
        this.bookRight = this.width / 2 + 145;
        this.bookBottom = this.height / 2 + 94;
    }

    public void addBackButton(Screen parentScreen) {
        this.addBackButton(parentScreen, b -> {});
    }

    public void addBackButton(Screen parentScreen, Consumer<Button> onPress) {
        this.addRenderableWidget((GuiEventListener)new NuggetImageButton(this.bookLeft + 6, this.bookTop + 6, DocAssets.ARROW_BACK_HOVER.width(), DocAssets.ARROW_BACK_HOVER.height(), DocAssets.ARROW_BACK.location(), DocAssets.ARROW_BACK_HOVER.location(), b -> {
            if (onPress != null) {
                onPress.accept(b);
            }
            Minecraft.getInstance().setScreen(parentScreen);
        }));
    }

    public void addSaveButton(Button.OnPress onPress) {
        this.saveButton = (SaveButton)this.addRenderableWidget((GuiEventListener)new SaveButton(this.bookRight - DocAssets.SAVE_ICON.width() - 18, this.bookBottom - DocAssets.SAVE_ICON.height() + 2, onPress));
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        PoseStack matrixStack = graphics.pose();
        matrixStack.pushPose();
        if (this.scaleFactor != 1.0f) {
            matrixStack.scale(this.scaleFactor, this.scaleFactor, this.scaleFactor);
            mouseX = (int)((float)mouseX / this.scaleFactor);
            mouseY = (int)((float)mouseY / this.scaleFactor);
        }
        this.drawScreenAfterScale(graphics, mouseX, mouseY, partialTicks);
        matrixStack.popPose();
    }

    public <T extends ANButton> void clearButtons(List<T> buttons) {
        for (ANButton b : buttons) {
            this.renderables.remove(b);
            this.children().remove(b);
        }
        buttons.clear();
    }

    public void drawBackgroundElements(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.blit(background, 0, 0, 0.0f, 0.0f, 290, 188, 290, 188);
    }

    public void drawForegroundElements(int mouseX, int mouseY, float partialTicks) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void drawScreenAfterScale(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate((float)this.bookLeft, (float)this.bookTop, 0.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawBackgroundElements(graphics, mouseX, mouseY, partialTicks);
        this.drawForegroundElements(mouseX, mouseY, partialTicks);
        poseStack.popPose();
        for (Renderable renderable : this.renderables) {
            renderable.render(graphics, mouseX, mouseY, partialTicks);
        }
        this.drawTooltip(graphics, mouseX, mouseY);
    }

    public void collectTooltips(GuiGraphics stack, int mouseX, int mouseY, List<Component> tooltip) {
        for (Renderable renderable : this.renderables) {
            if (!(renderable instanceof AbstractWidget)) continue;
            AbstractWidget widget = (AbstractWidget)renderable;
            if (!widget.visible || !GuiUtils.isMouseInRelativeRange(mouseX, mouseY, widget)) continue;
            if (renderable instanceof ITooltipProvider) {
                ITooltipProvider tooltipProvider = (ITooltipProvider)renderable;
                tooltipProvider.getTooltip(tooltip);
                continue;
            }
            if (!(renderable instanceof ITooltipRenderer)) continue;
            ITooltipRenderer nuggetProvider = (ITooltipRenderer)renderable;
            nuggetProvider.gatherTooltips(tooltip);
        }
    }

    @Nullable
    public Renderable getHoveredRenderable(int mouseX, int mouseY) {
        for (Renderable renderable : this.renderables) {
            AbstractWidget widget;
            if (!(renderable instanceof AbstractWidget) || !GuiUtils.isMouseInRelativeRange(mouseX, mouseY, widget = (AbstractWidget)renderable)) continue;
            return renderable;
        }
        return null;
    }

    public BookSlider buildSlider(int x, int y, Component prefix, Component suffix, double currentVal) {
        return new BookSlider(x, y, 100, 20, prefix, suffix, 1.0, 255.0, currentVal, 1.0, 1, true);
    }

    protected void renderBlurredBackground(float pPartialTick) {
    }
}

