/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui;

import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class NoShadowTextField
extends EditBox {
    public Function<String, Void> onClear;

    public NoShadowTextField(Font font, int x, int y, int width, int height, Component message) {
        super(font, x, y, width, height, message);
    }

    public NoShadowTextField(Font font, int x, int y, int width, int height, @Nullable EditBox editBox, Component message) {
        super(font, x, y, width, height, editBox, message);
    }

    public void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (!this.visible) {
            return;
        }
        int textColor = this.isEditable ? this.textColor : this.textColorUneditable;
        int offset = this.cursorPos - this.displayPos;
        String s = this.font.plainSubstrByWidth(this.value.substring(this.displayPos), this.getInnerWidth());
        int selectionVisualEnd = Mth.clamp((int)(this.highlightPos - this.displayPos), (int)0, (int)s.length());
        boolean offsetInBounds = offset >= 0 && offset <= s.length();
        boolean shouldFlash = this.isFocused() && (Util.getMillis() - this.focusedTime) / 300L % 2L == 0L && offsetInBounds;
        int xStart = this.bordered ? this.x + 4 : this.x;
        int yStart = this.bordered ? this.y + (this.height - 8) / 2 : this.y;
        int textStartX = xStart;
        if (!s.isEmpty()) {
            String s1 = offsetInBounds ? s.substring(0, offset) : s;
            textStartX = graphics.drawString(this.font, (FormattedCharSequence)this.formatter.apply(s1, this.displayPos), xStart, yStart, -8355712, false);
        }
        boolean outOfSpace = this.font.width(s + "_") > this.width;
        int decorationStartX = textStartX;
        if (!offsetInBounds) {
            decorationStartX = offset > 0 ? xStart + this.width : xStart;
        } else if (outOfSpace) {
            decorationStartX = textStartX - 1;
            --textStartX;
        }
        if (!s.isEmpty() && offsetInBounds && offset < s.length()) {
            graphics.drawString(this.font, (FormattedCharSequence)this.formatter.apply(s.substring(offset), this.cursorPos), textStartX, yStart, textColor);
        }
        if (!outOfSpace && this.suggestion != null && (this.value == null || this.value.isEmpty())) {
            graphics.drawString(this.font, this.suggestion, decorationStartX - 1, yStart, -8355712, false);
        }
        if (shouldFlash) {
            if (outOfSpace) {
                graphics.fill(decorationStartX, yStart - 1, decorationStartX + 1, yStart + 1 + 9, -3092272);
            } else {
                graphics.drawString(this.font, "_", decorationStartX, yStart, textColor, false);
            }
        }
        if (selectionVisualEnd != offset) {
            int selectionVisualEndX = xStart + this.font.width(s.substring(0, selectionVisualEnd));
            this.renderHighlight(graphics, decorationStartX, yStart - 1, selectionVisualEndX - 1, yStart + 9);
        }
    }

    private void renderHighlight(GuiGraphics guiGraphics, int minX, int minY, int maxX, int maxY) {
        if (minX < maxX) {
            int i = minX;
            minX = maxX;
            maxX = i;
        }
        if (minY < maxY) {
            int j = minY;
            minY = maxY;
            maxY = j;
        }
        if (maxX > this.getX() + this.width) {
            maxX = this.getX() + this.width;
        }
        if (minX > this.getX() + this.width) {
            minX = this.getX() + this.width;
        }
        guiGraphics.fill(RenderType.guiTextHighlight(), minX, minY, maxX, maxY, FastColor.ARGB32.color((int)255, (int)0, (int)0, (int)255));
    }

    public boolean mouseClicked(double clickedX, double clickedY, int mouseButton) {
        boolean clickedThis;
        if (!this.isVisible()) {
            return false;
        }
        boolean bl = clickedThis = clickedX >= (double)this.x && clickedX < (double)(this.x + this.width) && clickedY >= (double)this.y && clickedY < (double)(this.y + this.height);
        if (this.canLoseFocus) {
            this.setFocused(clickedThis);
        }
        if (this.isFocused() && clickedThis && mouseButton == 0) {
            int i = Mth.floor((double)clickedX) - this.x;
            if (this.bordered) {
                i -= 4;
            }
            String s = this.font.plainSubstrByWidth(this.value.substring(this.displayPos), this.getInnerWidth());
            this.moveCursorTo(this.font.plainSubstrByWidth(s, i).length() + this.displayPos, true);
            return true;
        }
        if (this.isFocused() && mouseButton == 1) {
            if (this.value.isEmpty()) {
                return clickedThis;
            }
            if (this.onClear != null) {
                this.onClear.apply("");
            }
            this.setValue("");
            return clickedThis;
        }
        return false;
    }
}

