/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.particle.timelines;

import com.google.common.collect.ImmutableList;
import com.hollingsworth.arsnouveau.api.particle.configurations.IParticleMotionType;
import com.hollingsworth.arsnouveau.api.particle.configurations.LightBlobMotion;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.BaseProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.MotionProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.SoundProperty;
import com.hollingsworth.arsnouveau.api.particle.timelines.BaseTimeline;
import com.hollingsworth.arsnouveau.api.particle.timelines.IParticleTimelineType;
import com.hollingsworth.arsnouveau.api.particle.timelines.TimelineEntryData;
import com.hollingsworth.arsnouveau.api.particle.timelines.TimelineOption;
import com.hollingsworth.arsnouveau.api.registry.ParticleTimelineRegistry;
import com.hollingsworth.arsnouveau.api.sound.ConfiguredSpellSound;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public class PrestidigitationTimeline
extends BaseTimeline<PrestidigitationTimeline> {
    public static final MapCodec<PrestidigitationTimeline> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TimelineEntryData.CODEC.fieldOf("onResolvingEffect").forGetter(i -> i.onTickEffect), (App)SoundProperty.CODEC.fieldOf("randomSound").forGetter(i -> i.randomSound)).apply((Applicative)instance, PrestidigitationTimeline::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, PrestidigitationTimeline> STREAM_CODEC = StreamCodec.composite(TimelineEntryData.STREAM, PrestidigitationTimeline::tickingEffect, SoundProperty.STREAM_CODEC, PrestidigitationTimeline::randomSound, PrestidigitationTimeline::new);
    public static final List<IParticleMotionType<?>> TICKING_OPTIONS = new CopyOnWriteArrayList();
    public TimelineEntryData onTickEffect;
    public SoundProperty randomSound = new SoundProperty();

    public PrestidigitationTimeline() {
        this(new TimelineEntryData(new LightBlobMotion()), new SoundProperty(ConfiguredSpellSound.EMPTY));
    }

    public PrestidigitationTimeline(TimelineEntryData onTickEffect, SoundProperty randomSound) {
        this.onTickEffect = onTickEffect;
        this.randomSound = randomSound;
    }

    public TimelineEntryData tickingEffect() {
        return this.onTickEffect;
    }

    public SoundProperty randomSound() {
        return this.randomSound;
    }

    @Override
    public IParticleTimelineType<PrestidigitationTimeline> getType() {
        return (IParticleTimelineType)ParticleTimelineRegistry.PRESTIDIGITATION_TIMELINE.get();
    }

    @Override
    public List<BaseProperty<?>> getProperties() {
        return List.of(new MotionProperty(new TimelineOption(TimelineOption.TICK, this.onTickEffect, ImmutableList.copyOf(TICKING_OPTIONS)), List.of(this.randomSound)));
    }
}

