/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.setup.config;

import java.util.HashMap;
import java.util.function.Function;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class CommonConfig {
    public final HashMap<String, ModConfigSpec.ConfigValue<?>> config = new HashMap();
    private final ModConfigSpec.BooleanValue chunkloading_recipe_enabled;
    private final ModConfigSpec.BooleanValue ruined_warp_portals_enabled;
    private final ModConfigSpec.BooleanValue nexus_tower_enabled;
    private final ModConfigSpec.BooleanValue arcane_library_enabled;
    public static final CommonConfig COMMON;
    public static final ModConfigSpec COMMON_SPEC;

    CommonConfig(ModConfigSpec.Builder builder) {
        builder.comment("Ritual of Arcane Permanence").push("chunkloading");
        this.chunkloading_recipe_enabled = this.addConfig("ritual_enabled", name -> builder.comment("Should the default recipe for the ritual be enabled?").define(name, false));
        builder.pop();
        builder.comment("Structures").push("structures");
        this.ruined_warp_portals_enabled = this.addConfig("ruined_warp_portals_enabled", name -> builder.comment("Should ruined warp portals spawn in the world?").define(name, true));
        this.nexus_tower_enabled = this.addConfig("nexus_tower_enabled", name -> builder.comment("Should nexus towers spawn in the world?").define(name, true));
        this.arcane_library_enabled = this.addConfig("arcane_library_enabled", name -> builder.comment("Should arcane libraries spawn in the world?").define(name, true));
        builder.pop();
    }

    public <T extends ModConfigSpec.ConfigValue<?>> T addConfig(String name, Function<String, T> consumer) {
        ModConfigSpec.ConfigValue value = (ModConfigSpec.ConfigValue)consumer.apply(name);
        this.config.put(name, value);
        return (T)value;
    }

    static {
        Pair pair = new ModConfigSpec.Builder().configure(CommonConfig::new);
        COMMON_SPEC = (ModConfigSpec)pair.getRight();
        COMMON = (CommonConfig)pair.getLeft();
    }
}

