/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.another_furniture.block;

import com.starfish_studios.another_furniture.block.properties.ModBlockStateProperties;
import com.starfish_studios.another_furniture.registry.AFBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TableBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty LEG1 = ModBlockStateProperties.LEG_1;
    public static final BooleanProperty LEG2 = ModBlockStateProperties.LEG_2;
    public static final BooleanProperty LEG3 = ModBlockStateProperties.LEG_3;
    public static final BooleanProperty LEG4 = ModBlockStateProperties.LEG_4;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty UPDATE = ModBlockStateProperties.UPDATE;
    protected static final VoxelShape TOP = Block.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape LEG_1 = Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)2.0);
    protected static final VoxelShape LEG_2 = Block.box((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)14.0, (double)16.0);
    protected static final VoxelShape LEG_3 = Block.box((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)14.0, (double)16.0);
    protected static final VoxelShape LEG_4 = Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0);
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{TOP, Shapes.or((VoxelShape)TOP, (VoxelShape)LEG_1), Shapes.or((VoxelShape)TOP, (VoxelShape)LEG_2), Shapes.or((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_1, LEG_2}), Shapes.or((VoxelShape)TOP, (VoxelShape)LEG_3), Shapes.or((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_1, LEG_3}), Shapes.or((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_2, LEG_3}), Shapes.or((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_1, LEG_2, LEG_3}), Shapes.or((VoxelShape)TOP, (VoxelShape)LEG_4), Shapes.or((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_1, LEG_4}), Shapes.or((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_2, LEG_4}), Shapes.or((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_1, LEG_2, LEG_4}), Shapes.or((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_3, LEG_4}), Shapes.or((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_1, LEG_3, LEG_4}), Shapes.or((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_2, LEG_3, LEG_4}), Shapes.or((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{LEG_1, LEG_2, LEG_3, LEG_4})};

    public TableBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)LEG1, (Comparable)Boolean.valueOf(true))).setValue((Property)LEG2, (Comparable)Boolean.valueOf(true))).setValue((Property)LEG3, (Comparable)Boolean.valueOf(true))).setValue((Property)LEG4, (Comparable)Boolean.valueOf(true))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int shape = 0;
        if (((Boolean)state.getValue((Property)LEG1)).booleanValue()) {
            ++shape;
        }
        if (((Boolean)state.getValue((Property)LEG2)).booleanValue()) {
            shape += 2;
        }
        if (((Boolean)state.getValue((Property)LEG3)).booleanValue()) {
            shape += 4;
        }
        if (((Boolean)state.getValue((Property)LEG4)).booleanValue()) {
            shape += 8;
        }
        return SHAPES[shape];
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean waterlogged = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        BlockState state = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
        return this.getConnections(state, (LevelAccessor)context.getLevel(), context.getClickedPos());
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return this.getConnections(state, level, currentPos);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, LEG1, LEG2, LEG3, LEG4, UPDATE, WATERLOGGED});
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        boolean leg1 = (Boolean)state.getValue((Property)LEG1);
        boolean leg2 = (Boolean)state.getValue((Property)LEG2);
        boolean leg3 = (Boolean)state.getValue((Property)LEG3);
        boolean leg4 = (Boolean)state.getValue((Property)LEG4);
        return switch (rotation) {
            default -> throw new MatchException(null, null);
            case Rotation.NONE -> (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
            case Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)))).setValue((Property)LEG1, (Comparable)Boolean.valueOf(leg4))).setValue((Property)LEG2, (Comparable)Boolean.valueOf(leg1))).setValue((Property)LEG3, (Comparable)Boolean.valueOf(leg2))).setValue((Property)LEG4, (Comparable)Boolean.valueOf(leg3));
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)))).setValue((Property)LEG1, (Comparable)Boolean.valueOf(leg3))).setValue((Property)LEG2, (Comparable)Boolean.valueOf(leg4))).setValue((Property)LEG3, (Comparable)Boolean.valueOf(leg1))).setValue((Property)LEG4, (Comparable)Boolean.valueOf(leg2));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)))).setValue((Property)LEG1, (Comparable)Boolean.valueOf(leg2))).setValue((Property)LEG2, (Comparable)Boolean.valueOf(leg3))).setValue((Property)LEG3, (Comparable)Boolean.valueOf(leg4))).setValue((Property)LEG4, (Comparable)Boolean.valueOf(leg1));
        };
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public BlockState getConnections(BlockState state, LevelAccessor level, BlockPos pos) {
        boolean n = this.validConnection(level.getBlockState(pos.north()));
        boolean e = this.validConnection(level.getBlockState(pos.east()));
        boolean s = this.validConnection(level.getBlockState(pos.south()));
        boolean w = this.validConnection(level.getBlockState(pos.west()));
        boolean leg1 = !n && !e || n && e && !this.validConnection(level.getBlockState(pos.north().east()));
        boolean leg2 = !e && !s || e && s && !this.validConnection(level.getBlockState(pos.south().east()));
        boolean leg3 = !s && !w || s && w && !this.validConnection(level.getBlockState(pos.south().west()));
        boolean leg4 = !n && !w || n && w && !this.validConnection(level.getBlockState(pos.north().west()));
        boolean update = ((n ? 1 : 0) + (e ? 1 : 0) + (s ? 1 : 0) + (w ? 1 : 0)) % 2 == 0;
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)LEG1, (Comparable)Boolean.valueOf(leg1))).setValue((Property)LEG2, (Comparable)Boolean.valueOf(leg2))).setValue((Property)LEG3, (Comparable)Boolean.valueOf(leg3))).setValue((Property)LEG4, (Comparable)Boolean.valueOf(leg4))).setValue((Property)UPDATE, (Comparable)Boolean.valueOf(update));
    }

    public boolean validConnection(BlockState state) {
        return state.is(AFBlockTags.TABLES_CONNECTABLE);
    }
}

