/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.another_furniture.block;

import com.starfish_studios.another_furniture.block.LampBlock;
import com.starfish_studios.another_furniture.block.properties.ModBlockStateProperties;
import com.starfish_studios.another_furniture.registry.AFBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class LampConnectorBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty BASE = ModBlockStateProperties.BASE;
    protected static final VoxelShape AABB_NOT_BASE = Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    protected static final VoxelShape AABB_BASE = Shapes.or((VoxelShape)Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)2.0, (double)11.0), (VoxelShape)Block.box((double)7.0, (double)2.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0));
    private final DyeColor color;

    public LampConnectorBlock(DyeColor color, BlockBehaviour.Properties properties) {
        super(properties);
        this.color = color;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)BASE, (Comparable)Boolean.valueOf(true)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)BASE) != false ? AABB_BASE : AABB_NOT_BASE;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean waterlogged = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState blockstate = this.defaultBlockState();
        if (level.hasNeighborSignal(pos)) {
            blockstate = (BlockState)blockstate.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true));
        }
        return (BlockState)blockstate.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        if (direction == Direction.UP || direction == Direction.DOWN) {
            LampConnectorBlock connectorBlock;
            LampBlock lampBlock;
            boolean bConnect;
            LampConnectorBlock connectorBlock2;
            LampBlock lampBlock2;
            BlockState aState = level.getBlockState(currentPos.above());
            BlockState bState = level.getBlockState(currentPos.below());
            Block block = aState.getBlock();
            boolean aConnect = block instanceof LampBlock && (lampBlock2 = (LampBlock)block).getColor() == this.getColor() && aState.getValue((Property)LampBlock.FACING) == Direction.UP || (block = aState.getBlock()) instanceof LampConnectorBlock && (connectorBlock2 = (LampConnectorBlock)block).getColor() == this.getColor();
            Block block2 = bState.getBlock();
            boolean bl = bConnect = block2 instanceof LampBlock && (lampBlock = (LampBlock)block2).getColor() == this.getColor() && bState.getValue((Property)LampBlock.FACING) == Direction.UP || (block2 = bState.getBlock()) instanceof LampConnectorBlock && (connectorBlock = (LampConnectorBlock)block2).getColor() == this.getColor();
            state = aConnect && !bConnect ? (BlockState)state.setValue((Property)BASE, (Comparable)Boolean.valueOf(true)) : (!aConnect && bConnect ? (BlockState)((BlockState)LampConnectorBlock.getLampByColor(this.color).defaultBlockState().setValue((Property)BASE, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)WATERLOGGED))) : (aConnect ? (BlockState)state.setValue((Property)BASE, (Comparable)Boolean.valueOf(false)) : (BlockState)((BlockState)LampConnectorBlock.getLampByColor(this.color).defaultBlockState().setValue((Property)BASE, (Comparable)Boolean.valueOf(true))).setValue((Property)WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)WATERLOGGED)))));
        }
        return state;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean powered;
        if (level.isClientSide) {
            return;
        }
        BlockState below = level.getBlockState(pos.below());
        boolean bl = powered = level.hasNeighborSignal(pos) || below.getBlock() instanceof LampConnectorBlock && (Boolean)below.getValue((Property)POWERED) != false;
        if (powered != (Boolean)state.getValue((Property)POWERED)) {
            state = (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(powered));
        }
        level.setBlock(pos, state, 3);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, POWERED, BASE});
    }

    public DyeColor getColor() {
        return this.color;
    }

    public static Block getLampByColor(DyeColor color) {
        return switch (color) {
            default -> throw new MatchException(null, null);
            case DyeColor.WHITE -> AFBlocks.WHITE_LAMP.get();
            case DyeColor.ORANGE -> AFBlocks.ORANGE_LAMP.get();
            case DyeColor.MAGENTA -> AFBlocks.MAGENTA_LAMP.get();
            case DyeColor.LIGHT_BLUE -> AFBlocks.LIGHT_BLUE_LAMP.get();
            case DyeColor.YELLOW -> AFBlocks.YELLOW_LAMP.get();
            case DyeColor.LIME -> AFBlocks.LIME_LAMP.get();
            case DyeColor.PINK -> AFBlocks.PINK_LAMP.get();
            case DyeColor.GRAY -> AFBlocks.GRAY_LAMP.get();
            case DyeColor.LIGHT_GRAY -> AFBlocks.LIGHT_GRAY_LAMP.get();
            case DyeColor.CYAN -> AFBlocks.CYAN_LAMP.get();
            case DyeColor.PURPLE -> AFBlocks.PURPLE_LAMP.get();
            case DyeColor.BLUE -> AFBlocks.BLUE_LAMP.get();
            case DyeColor.BROWN -> AFBlocks.BROWN_LAMP.get();
            case DyeColor.GREEN -> AFBlocks.GREEN_LAMP.get();
            case DyeColor.RED -> AFBlocks.RED_LAMP.get();
            case DyeColor.BLACK -> AFBlocks.BLACK_LAMP.get();
        };
    }
}

