/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.another_furniture.block;

import com.mojang.serialization.MapCodec;
import com.starfish_studios.another_furniture.block.entity.FlowerBoxBlockEntity;
import com.starfish_studios.another_furniture.block.properties.HorizontalConnectionType;
import com.starfish_studios.another_furniture.block.properties.ModBlockStateProperties;
import com.starfish_studios.another_furniture.registry.AFItemTags;
import com.starfish_studios.another_furniture.util.block.BlockPart;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FlowerBoxBlock
extends BaseEntityBlock {
    public static final MapCodec<FlowerBoxBlock> CODEC = FlowerBoxBlock.simpleCodec(FlowerBoxBlock::new);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<HorizontalConnectionType> TYPE = ModBlockStateProperties.HORIZONTAL_CONNECTION_TYPE;
    public static final BooleanProperty ATTACHED = BlockStateProperties.ATTACHED;
    protected static final VoxelShape NORTH_AABB = Block.box((double)0.0, (double)10.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH_AABB = Block.box((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final VoxelShape WEST_AABB = Block.box((double)8.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.box((double)0.0, (double)10.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    protected static final VoxelShape Z_AXIS_AABB = Block.box((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)6.0, (double)12.0);
    protected static final VoxelShape X_AXIS_AABB = Block.box((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)6.0, (double)16.0);

    public MapCodec<FlowerBoxBlock> codec() {
        return CODEC;
    }

    public FlowerBoxBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(TYPE, (Comparable)((Object)HorizontalConnectionType.SINGLE))).setValue((Property)ATTACHED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        boolean attached = (Boolean)state.getValue((Property)ATTACHED);
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.WEST -> {
                if (attached) {
                    yield WEST_AABB;
                }
                yield X_AXIS_AABB;
            }
            case Direction.EAST -> {
                if (attached) {
                    yield EAST_AABB;
                }
                yield X_AXIS_AABB;
            }
            case Direction.SOUTH -> {
                if (attached) {
                    yield SOUTH_AABB;
                }
                yield Z_AXIS_AABB;
            }
            default -> attached ? NORTH_AABB : Z_AXIS_AABB;
        };
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        if (((Boolean)state.getValue((Property)ATTACHED)).booleanValue()) {
            Direction direction = (Direction)state.getValue((Property)FACING);
            BlockPos facingPos = pos.relative(direction.getOpposite());
            BlockState facingState = level.getBlockState(facingPos);
            return facingState.isFaceSturdy((BlockGetter)level, facingPos, direction);
        }
        return super.canSurvive(state, level, pos);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        boolean r_side;
        BlockEntity blockentity;
        BlockState above = level.getBlockState(currentPos.above());
        boolean attached = (Boolean)state.getValue((Property)ATTACHED);
        if (direction == Direction.UP && attached && above.isFaceSturdy((BlockGetter)level, currentPos, Direction.DOWN) && (blockentity = level.getBlockEntity(currentPos)) instanceof FlowerBoxBlockEntity) {
            FlowerBoxBlockEntity flowerBoxBE = (FlowerBoxBlockEntity)blockentity;
            flowerBoxBE.removeAllItems();
            return state;
        }
        Direction facing = (Direction)state.getValue((Property)FACING);
        if (attached && direction.getOpposite() == facing && !state.canSurvive((LevelReader)level, currentPos)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (direction != facing.getClockWise() && direction != facing.getCounterClockWise()) {
            return state;
        }
        BlockState l_state = level.getBlockState(currentPos.relative(facing.getClockWise()));
        BlockState r_state = level.getBlockState(currentPos.relative(facing.getCounterClockWise()));
        boolean l_side = l_state.getBlock() instanceof FlowerBoxBlock && (Boolean)l_state.getValue((Property)ATTACHED) == attached && (l_state.getValue((Property)FACING) == facing || !attached && l_state.getValue((Property)FACING) == facing.getOpposite());
        boolean bl = r_side = r_state.getBlock() instanceof FlowerBoxBlock && (Boolean)r_state.getValue((Property)ATTACHED) == attached && (r_state.getValue((Property)FACING) == facing || !attached && r_state.getValue((Property)FACING) == facing.getOpposite());
        HorizontalConnectionType type = l_side && r_side ? HorizontalConnectionType.MIDDLE : (r_side ? HorizontalConnectionType.LEFT : (l_side ? HorizontalConnectionType.RIGHT : HorizontalConnectionType.SINGLE));
        return (BlockState)state.setValue(TYPE, (Comparable)((Object)type));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction clickedFace = context.getClickedFace();
        boolean attached = clickedFace != Direction.UP && clickedFace != Direction.DOWN;
        Direction facing = attached ? clickedFace : context.getHorizontalDirection().getOpposite();
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)ATTACHED, (Comparable)Boolean.valueOf(attached))).setValue((Property)FACING, (Comparable)facing);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, TYPE, ATTACHED});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FlowerBoxBlockEntity(pos, state);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof FlowerBoxBlockEntity)) {
            return ItemInteractionResult.FAIL;
        }
        FlowerBoxBlockEntity flowerBoxBE = (FlowerBoxBlockEntity)blockEntity;
        if (!stack.is(AFItemTags.FLOWER_BOX_PLACEABLES) || stack.is(AFItemTags.FLOWER_BOX_BANNED)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        Direction facing = (Direction)state.getValue((Property)FACING);
        int slot = BlockPart.get1D(pos, hitResult.getLocation(), facing.getClockWise(), 2);
        if (!level.isClientSide && flowerBoxBE.placeFlower(player.getAbilities().instabuild ? stack.copy() : stack, slot)) {
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.CONSUME;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.is(newState.getBlock())) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FlowerBoxBlockEntity) {
            FlowerBoxBlockEntity flowerBoxBE = (FlowerBoxBlockEntity)blockEntity;
            Containers.dropContents((Level)level, (BlockPos)pos, flowerBoxBE.getItems());
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

