/*
 * Decompiled with CFR 0.152.
 */
package com.autovw.advancednetherite.core.util;

import com.autovw.advancednetherite.core.ModItems;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public final class ModArmorMaterials {
    public static final Holder<ArmorMaterial> NETHERITE_IRON = ModArmorMaterials.register("netherite_iron", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), attribute -> {
        attribute.put(ArmorItem.Type.BOOTS, 4);
        attribute.put(ArmorItem.Type.LEGGINGS, 6);
        attribute.put(ArmorItem.Type.CHESTPLATE, 8);
        attribute.put(ArmorItem.Type.HELMET, 4);
        attribute.put(ArmorItem.Type.BODY, 11);
    }), 15, 3.5f, 0.1f, ModItems.NETHERITE_IRON_INGOT);
    public static final Holder<ArmorMaterial> NETHERITE_GOLD = ModArmorMaterials.register("netherite_gold", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), attribute -> {
        attribute.put(ArmorItem.Type.BOOTS, 4);
        attribute.put(ArmorItem.Type.LEGGINGS, 7);
        attribute.put(ArmorItem.Type.CHESTPLATE, 9);
        attribute.put(ArmorItem.Type.HELMET, 4);
        attribute.put(ArmorItem.Type.BODY, 11);
    }), 25, 3.5f, 0.1f, ModItems.NETHERITE_GOLD_INGOT);
    public static final Holder<ArmorMaterial> NETHERITE_EMERALD = ModArmorMaterials.register("netherite_emerald", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), attribute -> {
        attribute.put(ArmorItem.Type.BOOTS, 4);
        attribute.put(ArmorItem.Type.LEGGINGS, 7);
        attribute.put(ArmorItem.Type.CHESTPLATE, 9);
        attribute.put(ArmorItem.Type.HELMET, 4);
        attribute.put(ArmorItem.Type.BODY, 11);
    }), 20, 3.5f, 0.1f, ModItems.NETHERITE_EMERALD_INGOT);
    public static final Holder<ArmorMaterial> NETHERITE_DIAMOND = ModArmorMaterials.register("netherite_diamond", (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), attribute -> {
        attribute.put(ArmorItem.Type.BOOTS, 5);
        attribute.put(ArmorItem.Type.LEGGINGS, 7);
        attribute.put(ArmorItem.Type.CHESTPLATE, 9);
        attribute.put(ArmorItem.Type.HELMET, 5);
        attribute.put(ArmorItem.Type.BODY, 11);
    }), 15, 4.0f, 0.1f, ModItems.NETHERITE_DIAMOND_INGOT);

    private ModArmorMaterials() {
    }

    private static Holder<ArmorMaterial> register(String name, EnumMap<ArmorItem.Type, Integer> typeProtections, int enchantability, float toughness, float knockbackResistance, Item ingredientItem) {
        ResourceLocation loc = ResourceLocation.fromNamespaceAndPath((String)"advancednetherite", (String)name);
        Holder equipSound = SoundEvents.ARMOR_EQUIP_NETHERITE;
        Supplier<Ingredient> ingredient = () -> Ingredient.of((ItemLike[])new ItemLike[]{ingredientItem});
        List<ArmorMaterial.Layer> layers = List.of(new ArmorMaterial.Layer(loc));
        EnumMap<ArmorItem.Type, Integer> typeMap = new EnumMap<ArmorItem.Type, Integer>(ArmorItem.Type.class);
        for (ArmorItem.Type type : ArmorItem.Type.values()) {
            typeMap.put(type, typeProtections.get(type));
        }
        return Registry.registerForHolder((Registry)BuiltInRegistries.ARMOR_MATERIAL, (ResourceLocation)loc, (Object)new ArmorMaterial(typeProtections, enchantability, equipSound, ingredient, layers, toughness, knockbackResistance));
    }
}

