/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.world.processor;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.ribbits.module.StructureProcessorTypeModule;
import com.yungnickyoung.minecraft.yungsapi.api.world.randomize.BlockStateRandomizer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BlockReplaceProcessor
extends StructureProcessor {
    public static final MapCodec<BlockReplaceProcessor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockState.CODEC.fieldOf("target_block").forGetter(config -> config.targetBlock), (App)BlockStateRandomizer.CODEC.fieldOf("output").forGetter(config -> config.output), (App)Codec.BOOL.optionalFieldOf("randomize_facing", (Object)false).forGetter(config -> config.randomizeFacing), (App)Codec.BOOL.optionalFieldOf("randomize_half", (Object)false).forGetter(config -> config.randomizeHalf), (App)Codec.BOOL.optionalFieldOf("copy_input_properties", (Object)false).forGetter(config -> config.copyInputProperties), (App)Codec.BOOL.optionalFieldOf("preserve_waterlog", (Object)false).forGetter(config -> config.preserveWaterlog)).apply((Applicative)instance, instance.stable(BlockReplaceProcessor::new)));
    public final BlockState targetBlock;
    public final BlockStateRandomizer output;
    public final boolean randomizeFacing;
    public final boolean randomizeHalf;
    public final boolean copyInputProperties;
    public final boolean preserveWaterlog;

    private BlockReplaceProcessor(BlockState targetBlock, BlockStateRandomizer output, boolean randomizeFacing, boolean randomizeHalf, boolean copyInputProperties, boolean preserveWaterlog) {
        this.targetBlock = targetBlock;
        this.output = output;
        this.randomizeFacing = randomizeFacing;
        this.randomizeHalf = randomizeHalf;
        this.copyInputProperties = copyInputProperties;
        this.preserveWaterlog = preserveWaterlog;
    }

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoGlobal, StructurePlaceSettings structurePlacementData) {
        if (blockInfoGlobal.state().is(this.targetBlock.getBlock())) {
            RandomSource random = structurePlacementData.getRandom(blockInfoGlobal.pos());
            BlockState outputState = this.output.get(random);
            if (this.copyInputProperties) {
                if (blockInfoGlobal.state().hasProperty((Property)StairBlock.FACING) && outputState.hasProperty((Property)StairBlock.FACING)) {
                    outputState = (BlockState)outputState.setValue((Property)StairBlock.FACING, (Comparable)((Direction)blockInfoGlobal.state().getValue((Property)StairBlock.FACING)));
                }
                if (blockInfoGlobal.state().hasProperty((Property)StairBlock.HALF) && outputState.hasProperty((Property)StairBlock.HALF)) {
                    outputState = (BlockState)outputState.setValue((Property)StairBlock.HALF, (Comparable)((Half)blockInfoGlobal.state().getValue((Property)StairBlock.HALF)));
                }
                if (blockInfoGlobal.state().hasProperty((Property)StairBlock.SHAPE) && outputState.hasProperty((Property)StairBlock.SHAPE)) {
                    outputState = (BlockState)outputState.setValue((Property)StairBlock.SHAPE, (Comparable)((StairsShape)blockInfoGlobal.state().getValue((Property)StairBlock.SHAPE)));
                }
                if (blockInfoGlobal.state().hasProperty((Property)SlabBlock.TYPE) && outputState.hasProperty((Property)SlabBlock.TYPE)) {
                    outputState = (BlockState)outputState.setValue((Property)SlabBlock.TYPE, (Comparable)((SlabType)blockInfoGlobal.state().getValue((Property)SlabBlock.TYPE)));
                }
                if (blockInfoGlobal.state().hasProperty((Property)WallBlock.NORTH_WALL) && outputState.hasProperty((Property)WallBlock.NORTH_WALL)) {
                    outputState = (BlockState)outputState.setValue((Property)WallBlock.NORTH_WALL, (Comparable)((WallSide)blockInfoGlobal.state().getValue((Property)WallBlock.NORTH_WALL)));
                }
                if (blockInfoGlobal.state().hasProperty((Property)WallBlock.EAST_WALL) && outputState.hasProperty((Property)WallBlock.EAST_WALL)) {
                    outputState = (BlockState)outputState.setValue((Property)WallBlock.EAST_WALL, (Comparable)((WallSide)blockInfoGlobal.state().getValue((Property)WallBlock.EAST_WALL)));
                }
                if (blockInfoGlobal.state().hasProperty((Property)WallBlock.SOUTH_WALL) && outputState.hasProperty((Property)WallBlock.SOUTH_WALL)) {
                    outputState = (BlockState)outputState.setValue((Property)WallBlock.SOUTH_WALL, (Comparable)((WallSide)blockInfoGlobal.state().getValue((Property)WallBlock.SOUTH_WALL)));
                }
                if (blockInfoGlobal.state().hasProperty((Property)WallBlock.WEST_WALL) && outputState.hasProperty((Property)WallBlock.WEST_WALL)) {
                    outputState = (BlockState)outputState.setValue((Property)WallBlock.WEST_WALL, (Comparable)((WallSide)blockInfoGlobal.state().getValue((Property)WallBlock.WEST_WALL)));
                }
                if (blockInfoGlobal.state().hasProperty((Property)FenceBlock.NORTH) && outputState.hasProperty((Property)FenceBlock.NORTH)) {
                    outputState = (BlockState)outputState.setValue((Property)FenceBlock.NORTH, (Comparable)((Boolean)blockInfoGlobal.state().getValue((Property)FenceBlock.NORTH)));
                }
                if (blockInfoGlobal.state().hasProperty((Property)FenceBlock.EAST) && outputState.hasProperty((Property)FenceBlock.EAST)) {
                    outputState = (BlockState)outputState.setValue((Property)FenceBlock.EAST, (Comparable)((Boolean)blockInfoGlobal.state().getValue((Property)FenceBlock.EAST)));
                }
                if (blockInfoGlobal.state().hasProperty((Property)FenceBlock.SOUTH) && outputState.hasProperty((Property)FenceBlock.SOUTH)) {
                    outputState = (BlockState)outputState.setValue((Property)FenceBlock.SOUTH, (Comparable)((Boolean)blockInfoGlobal.state().getValue((Property)FenceBlock.SOUTH)));
                }
                if (blockInfoGlobal.state().hasProperty((Property)FenceBlock.WEST) && outputState.hasProperty((Property)FenceBlock.WEST)) {
                    outputState = (BlockState)outputState.setValue((Property)FenceBlock.WEST, (Comparable)((Boolean)blockInfoGlobal.state().getValue((Property)FenceBlock.WEST)));
                }
                if (blockInfoGlobal.state().hasProperty((Property)WallBlock.UP) && outputState.hasProperty((Property)WallBlock.UP)) {
                    outputState = (BlockState)outputState.setValue((Property)WallBlock.UP, (Comparable)((Boolean)blockInfoGlobal.state().getValue((Property)WallBlock.UP)));
                }
            }
            if (this.randomizeFacing) {
                if (outputState.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                    outputState = (BlockState)outputState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.Plane.HORIZONTAL.getRandomDirection(random));
                }
                if (outputState.hasProperty((Property)BlockStateProperties.FACING)) {
                    outputState = (BlockState)outputState.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.getRandom((RandomSource)random));
                }
            }
            if (this.randomizeHalf) {
                if (outputState.hasProperty((Property)BlockStateProperties.HALF)) {
                    outputState = (BlockState)outputState.setValue((Property)BlockStateProperties.HALF, (Comparable)(random.nextBoolean() ? Half.TOP : Half.BOTTOM));
                }
                if (outputState.hasProperty((Property)BlockStateProperties.DOUBLE_BLOCK_HALF)) {
                    outputState = (BlockState)outputState.setValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Comparable)(random.nextBoolean() ? DoubleBlockHalf.UPPER : DoubleBlockHalf.LOWER));
                }
                if (outputState.hasProperty((Property)BlockStateProperties.SLAB_TYPE)) {
                    outputState = (BlockState)outputState.setValue((Property)BlockStateProperties.SLAB_TYPE, (Comparable)(random.nextBoolean() ? SlabType.TOP : SlabType.BOTTOM));
                }
            }
            if (levelReader instanceof WorldGenRegion) {
                WorldGenRegion worldGenRegion = (WorldGenRegion)levelReader;
                if (outputState.is(Blocks.WATER) || outputState.is(Blocks.LAVA)) {
                    FlowingFluid fluid = outputState.is(Blocks.WATER) ? Fluids.WATER : Fluids.LAVA;
                    worldGenRegion.scheduleTick(blockInfoGlobal.pos(), (Fluid)fluid, 0);
                }
            }
            if (this.preserveWaterlog && outputState.hasProperty((Property)BlockStateProperties.WATERLOGGED) && blockInfoGlobal.state().hasProperty((Property)BlockStateProperties.WATERLOGGED) && ((Boolean)blockInfoGlobal.state().getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
                outputState = (BlockState)outputState.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true));
            }
            blockInfoGlobal = new StructureTemplate.StructureBlockInfo(blockInfoGlobal.pos(), outputState, blockInfoGlobal.nbt());
        }
        return blockInfoGlobal;
    }

    protected StructureProcessorType<?> getType() {
        return StructureProcessorTypeModule.BLOCK_REPLACE_PROCESSOR;
    }
}

