/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.mixin.mixins.client.music;

import com.mojang.blaze3d.audio.Channel;
import com.mojang.blaze3d.audio.SoundBuffer;
import com.yungnickyoung.minecraft.ribbits.client.sound.InstrumentSoundInstance;
import com.yungnickyoung.minecraft.ribbits.mixin.interfaces.client.IChannelDuck;
import com.yungnickyoung.minecraft.ribbits.mixin.mixins.client.accessor.SoundBufferAccessor;
import java.nio.IntBuffer;
import java.util.OptionalInt;
import net.minecraft.client.resources.sounds.SoundInstance;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.AL11;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Channel.class})
public class ChannelMixin
implements IChannelDuck {
    @Shadow
    @Final
    private int source;

    @Override
    public void ribbits$attachStaticBufferWithByteOffset(SoundInstance instance, SoundBuffer soundBuffer, int existingSoundSource) {
        OptionalInt bufferId = ((SoundBufferAccessor)soundBuffer).callGetAlBuffer();
        if (bufferId.isEmpty()) {
            return;
        }
        AL10.alSourcei((int)this.source, (int)4105, (int)bufferId.getAsInt());
        IntBuffer bytesToOffset = BufferUtils.createIntBuffer((int)1);
        if (existingSoundSource != 0) {
            AL10.alGetSourcei((int)existingSoundSource, (int)4134, (IntBuffer)bytesToOffset);
        }
        bytesToOffset.rewind();
        IntBuffer byteOffset = BufferUtils.createIntBuffer((int)1).put(existingSoundSource != 0 ? bytesToOffset.get() : 0);
        byteOffset.rewind();
        AL11.alSourceiv((int)this.source, (int)4134, (IntBuffer)byteOffset);
        if (instance instanceof InstrumentSoundInstance) {
            InstrumentSoundInstance ribbitInstrumentSoundInstance = (InstrumentSoundInstance)instance;
            ribbitInstrumentSoundInstance.setSourceId(this.source);
        }
    }

    @Override
    public void ribbits$attachStaticBufferWithTickOffset(SoundInstance instance, SoundBuffer soundBuffer, int ticksToOffset) {
        OptionalInt bufferId = ((SoundBufferAccessor)soundBuffer).callGetAlBuffer();
        if (bufferId.isEmpty()) {
            return;
        }
        AL10.alSourcei((int)this.source, (int)4105, (int)bufferId.getAsInt());
        int frequency = this.getBufferParameter(bufferId.getAsInt(), 8193);
        int samplesToOffset = (int)((float)ticksToOffset / 20.0f * (float)frequency);
        int sizeInBytes = this.getBufferParameter(bufferId.getAsInt(), 8196);
        int bitsPerSample = this.getBufferParameter(bufferId.getAsInt(), 8194);
        int channels = this.getBufferParameter(bufferId.getAsInt(), 8195);
        int lengthInSamples = sizeInBytes * 8 / (bitsPerSample * channels);
        IntBuffer sampleOffset = BufferUtils.createIntBuffer((int)1).put(samplesToOffset %= lengthInSamples);
        sampleOffset.rewind();
        AL11.alSourceiv((int)this.source, (int)4133, (IntBuffer)sampleOffset);
        if (instance instanceof InstrumentSoundInstance) {
            InstrumentSoundInstance ribbitInstrumentSoundInstance = (InstrumentSoundInstance)instance;
            ribbitInstrumentSoundInstance.setSourceId(this.source);
        }
    }

    @Unique
    private int getBufferParameter(int buffer, int param) {
        IntBuffer bufferParam = BufferUtils.createIntBuffer((int)1);
        AL10.alGetBufferi((int)buffer, (int)param, (IntBuffer)bufferParam);
        bufferParam.rewind();
        return bufferParam.get();
    }
}

