/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.data.recipe;

import com.blakebr0.mysticalagriculture.api.crop.Crop;
import com.blakebr0.mysticalagriculture.api.lib.LazyIngredient;
import com.blakebr0.mysticalagriculture.crafting.condition.CropEnabledCondition;
import com.blakebr0.mysticalagriculture.crafting.condition.CropHasMaterialCondition;
import com.blakebr0.mysticalagriculture.crafting.ingredient.CropComponentIngredient;
import com.blakebr0.mysticalagriculture.crafting.recipe.InfusionRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.NotCondition;
import net.neoforged.neoforge.common.conditions.TagEmptyCondition;

public class InfusionRecipeBuilder {
    private final NonNullList<Ingredient> inputs;
    private final ItemStack result;
    private final List<ICondition> conditions;
    private Ingredient input = Ingredient.EMPTY;

    public InfusionRecipeBuilder(ItemStack result) {
        this.inputs = NonNullList.withSize((int)8, (Object)Ingredient.EMPTY);
        this.result = result;
        this.conditions = new ArrayList<ICondition>();
    }

    public void addIngredient(int index, Ingredient ingredient) {
        this.inputs.set(index, (Object)ingredient);
    }

    public void addCondition(ICondition condition) {
        this.conditions.add(condition);
    }

    public void build(RecipeOutput consumer, ResourceLocation id) {
        consumer.accept(id, (Recipe)new InfusionRecipe(this.input, this.inputs, this.result, false), null, this.conditions.toArray(new ICondition[0]));
    }

    public static InfusionRecipeBuilder newSeedRecipe(Crop crop) {
        InfusionRecipeBuilder builder = new InfusionRecipeBuilder(new ItemStack((ItemLike)crop.getSeedsItem()));
        Ingredient essence = CropComponentIngredient.of(crop.getId(), CropComponentIngredient.ComponentType.ESSENCE);
        Ingredient seed = CropComponentIngredient.of(crop.getId(), CropComponentIngredient.ComponentType.SEED);
        Ingredient material = CropComponentIngredient.of(crop.getId(), CropComponentIngredient.ComponentType.MATERIAL);
        builder.input = seed;
        builder.addIngredient(0, material);
        builder.addIngredient(1, essence);
        builder.addIngredient(2, material);
        builder.addIngredient(3, essence);
        builder.addIngredient(4, material);
        builder.addIngredient(5, essence);
        builder.addIngredient(6, material);
        builder.addIngredient(7, essence);
        builder.addCondition(new CropEnabledCondition(crop.getId()));
        builder.addCondition(new CropHasMaterialCondition(crop.getId()));
        LazyIngredient ingredient = crop.getLazyIngredient();
        if (ingredient.isTag()) {
            builder.addCondition((ICondition)new NotCondition((ICondition)new TagEmptyCondition(ingredient.getId())));
        }
        return builder;
    }
}

