/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.recipe;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.Kiwi;
import snownee.kiwi.recipe.CustomIngredient;
import snownee.kiwi.recipe.CustomIngredientSerializer;

public class AlternativesIngredient
implements CustomIngredient {
    public static final ResourceLocation ID = Kiwi.id("alternatives");
    public static final Serializer SERIALIZER = new Serializer();
    @Nullable
    private final List<JsonElement> options;
    private Ingredient cached;

    public AlternativesIngredient(@Nullable List<JsonElement> options) {
        this.options = options;
    }

    @Override
    public boolean test(ItemStack stack) {
        return this.internal().test(stack);
    }

    @Override
    public List<ItemStack> getMatchingStacks() {
        return List.of(this.internal().getItems());
    }

    @Override
    public boolean requiresTesting() {
        return true;
    }

    @Override
    public CustomIngredientSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    public Ingredient internal() {
        if (this.cached == null) {
            Objects.requireNonNull(this.options);
            this.cached = Ingredient.EMPTY;
            for (JsonElement option : this.options) {
                Ingredient ingredient;
                try {
                    ingredient = (Ingredient)Ingredient.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)option).result().orElseThrow();
                }
                catch (Exception e) {
                    continue;
                }
                if (ingredient.getItems().length == 0) continue;
                this.cached = ingredient;
                break;
            }
        }
        return this.cached;
    }

    public static final class Serializer
    implements CustomIngredientSerializer<AlternativesIngredient> {
        public static final MapCodec<AlternativesIngredient> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.list((Codec)ExtraCodecs.JSON).fieldOf("options").forGetter(o -> o.options)).apply((Applicative)i, AlternativesIngredient::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, AlternativesIngredient> STREAM_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        public static AlternativesIngredient read(RegistryFriendlyByteBuf buf) {
            Ingredient internal = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf);
            AlternativesIngredient ingredient = new AlternativesIngredient(null);
            ingredient.cached = internal;
            return ingredient;
        }

        public static void write(RegistryFriendlyByteBuf buf, AlternativesIngredient ingredient) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)ingredient.internal());
        }

        @Override
        public ResourceLocation getIdentifier() {
            return ID;
        }

        @Override
        public MapCodec<AlternativesIngredient> getCodec(boolean allowEmpty) {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, AlternativesIngredient> getPacketCodec() {
            return STREAM_CODEC;
        }
    }
}

