/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.shape;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import snownee.kiwi.customization.shape.AbstractHorizontalShape;
import snownee.kiwi.customization.shape.BakingContext;
import snownee.kiwi.customization.shape.ShapeGenerator;
import snownee.kiwi.customization.shape.UnbakedShape;
import snownee.kiwi.customization.shape.UnbakedShapeCodec;
import snownee.kiwi.util.VoxelUtil;

public record HorizontalShape(VoxelShape[] shapes) implements AbstractHorizontalShape
{
    public static ShapeGenerator create(ShapeGenerator northGenerator) {
        VoxelShape north = ShapeGenerator.Unit.unboxOrThrow(northGenerator);
        if (VoxelUtil.isIsotropicHorizontally(north)) {
            return northGenerator;
        }
        VoxelShape[] shapes = new VoxelShape[4];
        shapes[Direction.NORTH.get2DDataValue()] = north;
        return new HorizontalShape(shapes);
    }

    @Override
    public Direction getDirection(BlockState blockState) {
        return (Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
    }

    public record Unbaked(UnbakedShape wrapped) implements UnbakedShape
    {
        public static Codec<Unbaked> codec(UnbakedShapeCodec parentCodec) {
            return RecordCodecBuilder.create(instance -> instance.group((App)parentCodec.fieldOf("north").forGetter(Unbaked::wrapped)).apply((Applicative)instance, Unbaked::new));
        }

        @Override
        public ShapeGenerator bake(BakingContext context) {
            return HorizontalShape.create(this.wrapped.bake(context));
        }

        @Override
        public Stream<UnbakedShape> dependencies() {
            return Stream.of(this.wrapped);
        }
    }
}

