/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.item.loader;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import snownee.kiwi.customization.block.loader.InjectedCodec;
import snownee.kiwi.customization.block.tier.KiwiTiers;
import snownee.kiwi.customization.item.MultipleBlockItem;
import snownee.kiwi.customization.item.loader.BuiltInItemTemplate;

public class ItemCodecs {
    private static final Map<ResourceLocation, MapCodec<Item>> CODECS = Maps.newHashMap();
    public static final String ITEM_PROPERTIES_KEY = "properties";
    private static final Codec<Item.Properties> ITEM_PROPERTIES = new InjectedCodec<Item.Properties>(Codec.unit(Item.Properties::new), BuiltInItemTemplate.PROPERTIES_INJECTOR);
    public static final Function<Item.Properties, Item> SIMPLE_ITEM_FACTORY = Item::new;
    public static final MapCodec<Item> ITEM = ItemCodecs.simpleCodec(SIMPLE_ITEM_FACTORY);

    public static <I extends Item> RecordCodecBuilder<I, Item.Properties> propertiesCodec() {
        return ITEM_PROPERTIES.fieldOf(ITEM_PROPERTIES_KEY).forGetter(item -> {
            throw new UnsupportedOperationException();
        });
    }

    public static <I extends Item> MapCodec<I> simpleCodec(Function<Item.Properties, I> function) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group(ItemCodecs.propertiesCodec()).apply((Applicative)instance, function));
    }

    public static <I extends TieredItem> MapCodec<I> tieredItemCodec(BiFunction<Tier, Item.Properties, I> function) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)KiwiTiers.CODEC.fieldOf("tier").forGetter(TieredItem::getTier), ItemCodecs.propertiesCodec()).apply((Applicative)instance, function));
    }

    public static void register(ResourceLocation key, MapCodec<? extends Item> codec) {
        CODECS.put(key, codec);
    }

    public static MapCodec<Item> get(ResourceLocation key) {
        return Objects.requireNonNull(CODECS.get(key), () -> ((ResourceLocation)key).toString());
    }

    static {
        ItemCodecs.register(ResourceLocation.withDefaultNamespace((String)"item"), ITEM);
        ItemCodecs.register(ResourceLocation.withDefaultNamespace((String)"blocks"), MultipleBlockItem.CODEC);
        ItemCodecs.register(ResourceLocation.withDefaultNamespace((String)"axe"), ItemCodecs.tieredItemCodec(AxeItem::new));
        ItemCodecs.register(ResourceLocation.withDefaultNamespace((String)"hoe"), ItemCodecs.tieredItemCodec(HoeItem::new));
        ItemCodecs.register(ResourceLocation.withDefaultNamespace((String)"pickaxe"), ItemCodecs.tieredItemCodec(PickaxeItem::new));
        ItemCodecs.register(ResourceLocation.withDefaultNamespace((String)"shovel"), ItemCodecs.tieredItemCodec(ShovelItem::new));
        ItemCodecs.register(ResourceLocation.withDefaultNamespace((String)"sword"), ItemCodecs.tieredItemCodec(SwordItem::new));
    }
}

