/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.block.loader;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import snownee.kiwi.Kiwi;
import snownee.kiwi.customization.CustomizationRegistries;
import snownee.kiwi.customization.block.BlockFundamentals;
import snownee.kiwi.customization.block.KBlockSettings;
import snownee.kiwi.customization.block.behavior.BlockBehaviorRegistry;
import snownee.kiwi.customization.block.component.KBlockComponent;
import snownee.kiwi.customization.block.loader.BlockDefinitionProperties;
import snownee.kiwi.customization.block.loader.ConfiguredBlockTemplate;
import snownee.kiwi.customization.block.loader.KBlockComponents;
import snownee.kiwi.customization.block.loader.KBlockTemplate;
import snownee.kiwi.customization.shape.BlockShapeType;
import snownee.kiwi.customization.shape.ChoicesShape;
import snownee.kiwi.customization.shape.ConfiguringShape;
import snownee.kiwi.customization.shape.DirectionalShape;
import snownee.kiwi.customization.shape.HorizontalShape;
import snownee.kiwi.customization.shape.MouldingShape;
import snownee.kiwi.customization.shape.ShapeGenerator;
import snownee.kiwi.customization.shape.ShapeStorage;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.util.VanillaActions;
import snownee.kiwi.util.VoxelUtil;

public record KBlockDefinition(ConfiguredBlockTemplate template, BlockDefinitionProperties properties) {
    public KBlockDefinition(ConfiguredBlockTemplate template, BlockDefinitionProperties properties) {
        this.template = template;
        this.properties = template.template().properties().map(properties::merge).orElse(properties);
    }

    public static Codec<KBlockDefinition> codec(Map<ResourceLocation, KBlockTemplate> templates, BlockFundamentals.CodecCreationContext context) {
        KBlockTemplate defaultTemplate = templates.get(ResourceLocation.withDefaultNamespace((String)"block"));
        Preconditions.checkNotNull((Object)defaultTemplate);
        ConfiguredBlockTemplate defaultConfiguredTemplate = new ConfiguredBlockTemplate(defaultTemplate);
        return RecordCodecBuilder.create(instance -> instance.group((App)ConfiguredBlockTemplate.codec(templates).optionalFieldOf("template", (Object)defaultConfiguredTemplate).forGetter(KBlockDefinition::template), (App)BlockDefinitionProperties.mapCodec(context).forGetter(KBlockDefinition::properties)).apply((Applicative)instance, KBlockDefinition::new));
    }

    public KBlockSettings.Builder createSettings(ResourceLocation id, ShapeStorage shapes) {
        KBlockSettings.Builder builder = KBlockSettings.builder();
        this.properties.glassType().ifPresent(builder::glassType);
        BlockDefinitionProperties.PartialVanillaProperties vanilla = this.properties.vanillaProperties();
        builder.configure($ -> {
            vanilla.lightEmission().ifPresent(i -> $.lightLevel($$ -> i));
            vanilla.pushReaction().ifPresent(arg_0 -> ((BlockBehaviour.Properties)$).pushReaction(arg_0));
            vanilla.emissiveRendering().ifPresent(arg_0 -> ((BlockBehaviour.Properties)$).emissiveRendering(arg_0));
            vanilla.hasPostProcess().ifPresent(arg_0 -> ((BlockBehaviour.Properties)$).hasPostProcess(arg_0));
            vanilla.isRedstoneConductor().ifPresent(arg_0 -> ((BlockBehaviour.Properties)$).isRedstoneConductor(arg_0));
            vanilla.isSuffocating().ifPresent(arg_0 -> ((BlockBehaviour.Properties)$).isSuffocating(arg_0));
            vanilla.isViewBlocking().ifPresent(arg_0 -> ((BlockBehaviour.Properties)$).isViewBlocking(arg_0));
            vanilla.isValidSpawn().ifPresent(arg_0 -> ((BlockBehaviour.Properties)$).isValidSpawn(arg_0));
            vanilla.offsetType().ifPresent(arg_0 -> ((BlockBehaviour.Properties)$).offsetType(arg_0));
            if (vanilla.noCollision().orElse(false).booleanValue()) {
                $.noCollission();
            }
            if (vanilla.noOcclusion().orElse(this.properties.glassType().isPresent()).booleanValue()) {
                $.noOcclusion();
            }
            if (vanilla.isRandomlyTicking().orElse(false).booleanValue()) {
                $.randomTicks();
            }
            if (vanilla.dynamicShape().orElse(false).booleanValue()) {
                $.dynamicShape();
            }
            if (vanilla.replaceable().orElse(false).booleanValue()) {
                $.replaceable();
            }
        });
        this.properties.material().ifPresent(mat -> builder.configure($ -> {
            $.strength(mat.destroyTime(), mat.explosionResistance());
            $.sound(mat.soundType());
            $.instrument(mat.instrument());
            $.mapColor(mat.defaultMapColor());
            if (mat.ignitedByLava()) {
                $.ignitedByLava();
            }
            if (mat.requiresCorrectToolForDrops()) {
                $.requiresCorrectToolForDrops();
            }
        }));
        if (this.properties.material().isEmpty()) {
            builder.configure($ -> $.strength(2.0f, 3.0f));
        }
        this.properties.canSurviveHandler().ifPresent(builder::canSurviveHandler);
        for (Either<KBlockComponent, String> component : this.properties.components()) {
            if (component.left().isPresent()) {
                builder.component((KBlockComponent)component.left().get());
                continue;
            }
            String s = (String)component.right().orElseThrow();
            boolean remove = s.startsWith("-");
            if (remove) {
                s = s.substring(1);
            }
            KBlockComponent.Type type = (KBlockComponent.Type)CustomizationRegistries.BLOCK_COMPONENT.get(ResourceLocation.parse((String)s));
            Preconditions.checkNotNull((Object)type, (String)"Unknown component type %s", (Object)s);
            if (remove) {
                builder.removeComponent(type);
                continue;
            }
            builder.component(KBlockComponents.getSimpleInstance(type));
        }
        if (!Platform.isDataGen()) {
            this.deriveAndSetShape(shapes, builder, BlockShapeType.MAIN, this.properties.shape());
            this.deriveAndSetShape(shapes, builder, BlockShapeType.COLLISION, this.properties.collisionShape());
            this.deriveAndSetShape(shapes, builder, BlockShapeType.INTERACTION, this.properties.interactionShape());
        }
        return builder;
    }

    public Block createBlock(ResourceLocation id, ShapeStorage shapes) {
        KBlockSettings.Builder builder = this.createSettings(id, shapes);
        Block block = this.template.template().createBlock(id, builder.get(), this.template.json());
        KBlockDefinition.setConfiguringShape(block, shapes);
        this.properties.material().ifPresent(mat -> VanillaActions.setFireInfo(block, mat.igniteOdds(), mat.burnOdds()));
        KBlockSettings settings = Objects.requireNonNull(KBlockSettings.of(block));
        BlockBehaviorRegistry behaviorRegistry = BlockBehaviorRegistry.getInstance();
        for (KBlockComponent component : settings.components.values()) {
            behaviorRegistry.setContext(block);
            component.addBehaviors(behaviorRegistry);
        }
        behaviorRegistry.setContext(null);
        return block;
    }

    public static void setConfiguringShape(Block block, ShapeStorage shapes) {
        KBlockSettings settings = KBlockSettings.of(block);
        if (settings == null) {
            return;
        }
        for (BlockShapeType shapeType : BlockShapeType.VALUES) {
            ConfiguringShape shape = settings.removeIfPossible(shapeType);
            if (shape == null) continue;
            shape.configure(block, shapeType, shapes);
        }
    }

    private void deriveAndSetShape(ShapeStorage shapes, KBlockSettings.Builder builder, BlockShapeType type, Optional<ResourceLocation> shapeId) {
        if (shapeId.isEmpty()) {
            return;
        }
        ShapeGenerator shape = shapes.get(shapeId.get());
        if (shape == null) {
            Kiwi.LOGGER.warn("Shape {} is not registered", (Object)shapeId.get());
            return;
        }
        if (shape.getClass() != ShapeGenerator.Unit.class) {
            builder.shape(type, shape);
            return;
        }
        if (builder.hasComponent(KBlockComponents.HORIZONTAL.getOrCreate())) {
            shape = shapes.transform(shape, KBlockComponents.HORIZONTAL.getOrCreate(), HorizontalShape::create);
        } else if (builder.hasComponent(KBlockComponents.DIRECTIONAL.getOrCreate())) {
            shape = shapes.transform(shape, KBlockComponents.DIRECTIONAL.getOrCreate(), $ -> DirectionalShape.create($, "facing"));
        } else if (builder.hasComponent(KBlockComponents.MOULDING.getOrCreate())) {
            shape = shapes.transform(shape, KBlockComponents.MOULDING.getOrCreate(), MouldingShape::create);
        } else if (builder.hasComponent(KBlockComponents.FRONT_AND_TOP.getOrCreate())) {
            shape = shapes.transform(shape, KBlockComponents.FRONT_AND_TOP.getOrCreate(), $ -> DirectionalShape.create($, "orientation"));
        } else if (builder.hasComponent(KBlockComponents.HORIZONTAL_AXIS.getOrCreate())) {
            shape = shapes.transform(shape, KBlockComponents.HORIZONTAL_AXIS.getOrCreate(), $ -> ChoicesShape.chooseOneProperty(BlockStateProperties.HORIZONTAL_AXIS, Map.of(Direction.Axis.X, $, Direction.Axis.Z, ShapeGenerator.unit(VoxelUtil.rotateHorizontal(ShapeGenerator.Unit.unboxOrThrow($), Direction.EAST)))));
        }
        builder.shape(type, shape);
    }
}

