/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.BooleanListEntry;
import me.shedaniel.clothconfig2.impl.builders.BooleanToggleBuilder;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import me.shedaniel.clothconfig2.impl.builders.TextDescriptionBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.config.ConfigHandler;
import snownee.kiwi.config.ConfigLibAttributes;
import snownee.kiwi.config.ConfigUI;
import snownee.kiwi.config.KiwiConfigManager;
import snownee.kiwi.util.KUtil;
import snownee.kiwi.util.LocalizableItem;

public class ClothConfigIntegration {
    private static final ConfigLibAttributes ATTRIBUTES = new ConfigLibAttributes("cloth-config", namespace -> ClothConfigIntegration.create(Minecraft.getInstance().screen, namespace), true, false, true);

    @Nullable
    public static Screen create(@Nullable Screen parent, String namespace) {
        ConfigBuilder builder = ConfigBuilder.create();
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        builder.setParentScreen(parent);
        List<ConfigHandler> configs = KiwiConfigManager.getModHandlersWithScreen(namespace, ATTRIBUTES);
        if (configs.isEmpty()) {
            return null;
        }
        for (ConfigHandler config : configs) {
            Object titleKey = "kiwi.config." + config.getTranslationKey();
            MutableComponent title = Component.translatable((String)titleKey);
            ConfigCategory category = builder.getOrCreateCategory((Component)title);
            HashMap subCatsMap = Maps.newHashMap();
            ArrayList subCats = Lists.newArrayList();
            subCatsMap.put("", arg_0 -> ((ConfigCategory)category).addEntry(arg_0));
            for (ConfigHandler.Value<?> value : config.getValueMap().values()) {
                ConfigUI.Typed typed;
                ConfigUI.Hide hide = value.getAnnotation(ConfigUI.Hide.class);
                if (hide != null) continue;
                ArrayList path = Lists.newArrayList((Object[])value.path.split("\\."));
                titleKey = (String)path.removeLast();
                String subCatKey = String.join((CharSequence)".", path);
                Consumer subCat = subCatsMap.computeIfAbsent(subCatKey, $ -> {
                    String key0 = namespace + ".config." + $;
                    MutableComponent title0 = I18n.exists((String)key0) ? Component.translatable((String)key0) : Component.literal((String)KUtil.friendlyText((String)path.getLast()));
                    SubCategoryBuilder builder0 = entryBuilder.startSubCategory((Component)title0);
                    builder0.setExpanded(true);
                    subCats.add(builder0);
                    return arg_0 -> ((SubCategoryBuilder)builder0).add(arg_0);
                });
                ConfigUI.TextDescription description = value.getAnnotation(ConfigUI.TextDescription.class);
                ClothConfigIntegration.putDescription(subCat, entryBuilder, description, false);
                title = I18n.exists((String)value.translation) ? Component.translatable((String)value.translation) : Component.literal((String)KUtil.friendlyText((String)titleKey));
                BooleanListEntry entry = null;
                Class<?> type = value.getType();
                if (type == Boolean.TYPE) {
                    BooleanToggleBuilder toggle = entryBuilder.startBooleanToggle((Component)title, ((Boolean)value.value).booleanValue());
                    toggle.setTooltip(value.createComment());
                    toggle.setSaveConsumer(value::accept);
                    toggle.setDefaultValue((Object)((Boolean)value.defValue));
                    entry = toggle.build();
                } else if (type == Integer.TYPE) {
                    ConfigUI.Color color = value.getAnnotation(ConfigUI.Color.class);
                    if (color != null) {
                        field = entryBuilder.startAlphaColorField((Component)title, ((Integer)value.value).intValue());
                        field.setAlphaMode(color.alpha());
                        field.setTooltip(value.createComment());
                        field.setSaveConsumer(value::accept);
                        field.setDefaultValue((Object)((Integer)value.defValue));
                        entry = field.build();
                    } else if (value.getAnnotation(ConfigUI.Slider.class) != null) {
                        field = entryBuilder.startIntSlider((Component)title, ((Integer)value.value).intValue(), (int)value.min, (int)value.max);
                        field.setTooltip(value.createComment());
                        field.setSaveConsumer(value::accept);
                        field.setDefaultValue((Object)((Integer)value.defValue));
                        entry = field.build();
                    } else {
                        field = entryBuilder.startIntField((Component)title, ((Integer)value.value).intValue());
                        field.setTooltip(value.createComment());
                        if (!Double.isNaN(value.min)) {
                            field.setMin((int)value.min);
                        }
                        if (!Double.isNaN(value.max)) {
                            field.setMax((int)value.max);
                        }
                        field.setSaveConsumer(value::accept);
                        field.setDefaultValue((Object)((Integer)value.defValue));
                        entry = field.build();
                    }
                } else if (type == Double.TYPE) {
                    field = entryBuilder.startDoubleField((Component)title, ((Double)value.value).doubleValue());
                    field.setTooltip(value.createComment());
                    if (!Double.isNaN(value.min)) {
                        field.setMin(value.min);
                    }
                    if (!Double.isNaN(value.max)) {
                        field.setMax(value.max);
                    }
                    field.setSaveConsumer(value::accept);
                    field.setDefaultValue((Object)((Double)value.defValue));
                    entry = field.build();
                } else if (type == Float.TYPE) {
                    field = entryBuilder.startFloatField((Component)title, ((Float)value.value).floatValue());
                    field.setTooltip(value.createComment());
                    if (!Double.isNaN(value.min)) {
                        field.setMin((float)value.min);
                    }
                    if (!Double.isNaN(value.max)) {
                        field.setMax((float)value.max);
                    }
                    field.setSaveConsumer(value::accept);
                    field.setDefaultValue((Object)((Float)value.defValue));
                    entry = field.build();
                } else if (type == Long.TYPE) {
                    if (value.getAnnotation(ConfigUI.Slider.class) != null) {
                        field = entryBuilder.startLongSlider((Component)title, ((Long)value.value).longValue(), (long)value.min, (long)value.max);
                        field.setTooltip(value.createComment());
                        field.setSaveConsumer(value::accept);
                        field.setDefaultValue((Object)((Long)value.defValue));
                        entry = field.build();
                    } else {
                        field = entryBuilder.startLongField((Component)title, ((Long)value.value).longValue());
                        field.setTooltip(value.createComment());
                        if (!Double.isNaN(value.min)) {
                            field.setMin((long)value.min);
                        }
                        if (!Double.isNaN(value.max)) {
                            field.setMax((long)value.max);
                        }
                        field.setSaveConsumer(value::accept);
                        field.setDefaultValue((Object)((Long)value.defValue));
                        entry = field.build();
                    }
                } else if (type == String.class) {
                    field = entryBuilder.startTextField((Component)title, (String)value.value);
                    field.setTooltip(value.createComment());
                    field.setSaveConsumer(value::accept);
                    field.setDefaultValue((String)value.defValue);
                    entry = field.build();
                } else if (Enum.class.isAssignableFrom(type)) {
                    field = entryBuilder.startEnumSelector((Component)title, type, (Enum)value.value);
                    field.setSaveConsumer(value::accept);
                    field.setDefaultValue((Enum)value.defValue);
                    field.setEnumNameProvider($ -> {
                        if ($ instanceof LocalizableItem) {
                            LocalizableItem item = (LocalizableItem)((Object)$);
                            return item.getDisplayName().copy();
                        }
                        return Component.literal((String)$.name());
                    });
                    field.setTooltipSupplier($ -> {
                        LocalizableItem item;
                        ArrayList tooltip = Lists.newArrayList();
                        if ($ instanceof LocalizableItem && (item = (LocalizableItem)((Object)$)).getDescription() != null) {
                            tooltip.add(item.getDisplayName().copy().append(" - ").append(item.getDescription()));
                        }
                        value.createComment().map(Arrays::asList).ifPresent(tooltip::addAll);
                        return tooltip.isEmpty() ? Optional.empty() : Optional.of((Component[])tooltip.toArray(Component[]::new));
                    });
                    entry = field.build();
                } else if (value.field != null && List.class.isAssignableFrom(type) && (typed = value.field.getAnnotation(ConfigUI.Typed.class)) != null && typed.value() == String.class) {
                    field = entryBuilder.startStrList((Component)title, (List)value.value);
                    field.setTooltip(value.createComment());
                    field.setSaveConsumer(value::accept);
                    field.setDefaultValue((List)value.defValue);
                    entry = field.build();
                }
                if (entry != null) {
                    entry.setRequiresRestart(value.requiresRestart);
                    subCat.accept(entry);
                }
                ClothConfigIntegration.putDescription(subCat, entryBuilder, description, true);
            }
            subCats.forEach($ -> category.addEntry((AbstractConfigListEntry)$.build()));
        }
        builder.setSavingRunnable(() -> configs.forEach(ConfigHandler::save));
        return builder.build();
    }

    private static void putDescription(Consumer<AbstractConfigListEntry<?>> subCat, ConfigEntryBuilder entryBuilder, @Nullable ConfigUI.TextDescription description, boolean after) {
        if (description == null || description.after() != after) {
            return;
        }
        MutableComponent component = Component.translatable((String)description.value());
        TextDescriptionBuilder builder = entryBuilder.startTextDescription((Component)component);
        subCat.accept((AbstractConfigListEntry<?>)builder.build());
    }

    public static ConfigLibAttributes attributes() {
        return ATTRIBUTES;
    }
}

