/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.world.entity.monster;

import fuzs.illagerinvasion.world.entity.ai.goal.PotionBowAttackGoal;
import java.util.List;
import java.util.stream.StreamSupport;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Alchemist
extends AbstractIllager
implements RangedAttackMob {
    private static final EntityDataAccessor<Boolean> DATA_HOLDING_POTION = SynchedEntityData.defineId(Alchemist.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_HOLDING_BOW = SynchedEntityData.defineId(Alchemist.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public int potionCooldown = 160;

    public Alchemist(EntityType<? extends Alchemist> entityType, Level world) {
        super(entityType, world);
        this.xpReward = 10;
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(4, new PotionBowAttackGoal<Alchemist>(this, 0.5, 20, 15.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.BOW));
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    public void performRangedAttack(LivingEntity target, float pullProgress) {
        ItemStack itemStack = this.getItemBySlot(EquipmentSlot.MAINHAND);
        PotionContents potionContents = (PotionContents)itemStack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
        if (itemStack.is(Items.LINGERING_POTION) && potionContents.potion().isPresent()) {
            Vec3 deltaMovement = target.getDeltaMovement();
            double d = target.getX() + deltaMovement.x - this.getX();
            double e = target.getEyeY() - 1.1 - this.getY();
            double f = target.getZ() + deltaMovement.z - this.getZ();
            double g = Math.sqrt(d * d + f * f);
            ThrownPotion potionEntity = new ThrownPotion(this.level(), (LivingEntity)this);
            Holder potion = (Holder)potionContents.potion().get();
            potionEntity.setItem(PotionContents.createItemStack((Item)Items.LINGERING_POTION, (Holder)potion));
            potionEntity.setXRot(potionEntity.getXRot() + 20.0f);
            potionEntity.shoot(d, e + g * 0.2, f, 0.75f, 8.0f);
            if (!this.isSilent()) {
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.WITCH_THROW, this.getSoundSource(), 1.0f, 0.8f + this.random.nextFloat() * 0.4f);
            }
            this.level().addFreshEntity((Entity)potionEntity);
            this.setBowState(true);
        } else {
            ItemStack itemInHand = this.getItemInHand(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, (Item)Items.BOW));
            ItemStack projectileItem = this.getProjectile(itemInHand);
            AbstractArrow persistentProjectileEntity = ProjectileUtil.getMobArrow((LivingEntity)this, (ItemStack)projectileItem, (float)pullProgress, (ItemStack)itemInHand);
            double d = target.getX() - this.getX();
            double e = target.getY(0.33) - persistentProjectileEntity.getY();
            double f = target.getZ() - this.getZ();
            double g = Math.sqrt(d * d + f * f);
            persistentProjectileEntity.shoot(d, e + g * 0.2, f, 1.6f, (float)(14 - this.level().getDifficulty().getId() * 4));
            this.playSound(SoundEvents.SKELETON_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
            this.level().addFreshEntity((Entity)persistentProjectileEntity);
        }
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        nbt.putBoolean("BowState", this.getBowState());
        nbt.putBoolean("PotionState", this.getPotionState());
        super.addAdditionalSaveData(nbt);
    }

    private void removeEffectsInCloud(AreaEffectCloud cloudEntity) {
        List nearbyIllagers = this.level().getEntitiesOfClass(AbstractIllager.class, cloudEntity.getBoundingBox().inflate(0.3), Entity::isAlive);
        for (LivingEntity entity : nearbyIllagers) {
            StreamSupport.stream(cloudEntity.potionContents.getAllEffects().spliterator(), false).findAny().map(MobEffectInstance::getEffect).ifPresent(arg_0 -> ((LivingEntity)entity).removeEffect(arg_0));
        }
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.setPotionState(nbt.getBoolean("PotionState"));
        this.setBowState(nbt.getBoolean("BowState"));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_HOLDING_POTION, (Object)false);
        builder.define(DATA_HOLDING_BOW, (Object)true);
    }

    public boolean getPotionState() {
        return (Boolean)this.entityData.get(DATA_HOLDING_POTION);
    }

    public void setPotionState(boolean potionState) {
        this.entityData.set(DATA_HOLDING_POTION, (Object)potionState);
    }

    public boolean getBowState() {
        return (Boolean)this.entityData.get(DATA_HOLDING_BOW);
    }

    public void setBowState(boolean bowState) {
        this.entityData.set(DATA_HOLDING_BOW, (Object)bowState);
    }

    public SoundEvent getCelebrateSound() {
        return SoundEvents.EVOKER_CELEBRATE;
    }

    protected void customServerAiStep() {
        List nearbyClouds = this.level().getEntitiesOfClass(AreaEffectCloud.class, this.getBoundingBox().inflate(30.0), Entity::isAlive);
        for (AreaEffectCloud areaEffectCloud : nearbyClouds) {
            this.removeEffectsInCloud(areaEffectCloud);
        }
        --this.potionCooldown;
        if (this.potionCooldown <= 0) {
            this.setPotionState(true);
            this.potionCooldown = 160;
        }
        ItemStack mainHandItem = this.getItemInHand(InteractionHand.MAIN_HAND);
        if (this.getBowState() && mainHandItem.is(Items.LINGERING_POTION)) {
            this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.BOW));
            this.setPotionState(false);
        }
        if (this.getPotionState() && mainHandItem.is(Items.BOW)) {
            Holder potion = switch (this.random.nextInt(3)) {
                case 0 -> Potions.POISON;
                case 1 -> Potions.SLOWNESS;
                case 2 -> Potions.WEAKNESS;
                default -> throw new RuntimeException();
            };
            this.setItemSlot(EquipmentSlot.MAINHAND, PotionContents.createItemStack((Item)Items.LINGERING_POTION, (Holder)potion));
            this.setBowState(false);
        }
        super.customServerAiStep();
    }

    public boolean canBeAffected(MobEffectInstance effectInstance) {
        return effectInstance.getEffect() != MobEffects.POISON && super.canBeAffected(effectInstance);
    }

    public boolean isAlliedTo(Entity other) {
        LivingEntity livingEntity;
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (super.isAlliedTo(other)) {
            return true;
        }
        if (other instanceof Vex) {
            return this.isAlliedTo((Entity)((Vex)other).getOwner());
        }
        return other instanceof LivingEntity && (livingEntity = (LivingEntity)other).getType().is(EntityTypeTags.ILLAGER_FRIENDS) && this.getTeam() == null && other.getTeam() == null;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.ILLUSIONER_AMBIENT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.ILLUSIONER_DEATH;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.ILLUSIONER_HURT;
    }

    public void applyRaidBuffs(ServerLevel level, int wave, boolean unused) {
    }

    public AbstractIllager.IllagerArmPose getArmPose() {
        if (this.isAggressive() && this.getItemBySlot(EquipmentSlot.MAINHAND).is(Items.BOW)) {
            return AbstractIllager.IllagerArmPose.BOW_AND_ARROW;
        }
        if (this.isAggressive() && this.getItemBySlot(EquipmentSlot.MAINHAND).is(Items.LINGERING_POTION)) {
            return AbstractIllager.IllagerArmPose.ATTACKING;
        }
        return AbstractIllager.IllagerArmPose.CROSSED;
    }
}

