/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndesires.register.client;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.function.BiConsumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.settings.KeyModifier;
import org.lwjgl.glfw.GLFW;

@EventBusSubscriber(modid="dndesires", value={Dist.CLIENT})
public enum DesiresKeys {
    HANDHELD_SAW_ACTIVATION("saw_active", 342, "Active Handheld Saw Action"),
    HANDHELD_DRILL_ACTIVATION("drill_active", 342, "Active Handheld Drill Action");

    private KeyMapping keybind;
    private final String description;
    private final String translation;
    private final int key;
    private final boolean modifiable;

    private DesiresKeys(int defaultKey) {
        this("", defaultKey, "");
    }

    private DesiresKeys(String description, int defaultKey, String translation) {
        this.description = "dndesires.keyinfo." + description;
        this.key = defaultKey;
        this.modifiable = !description.isEmpty();
        this.translation = translation;
    }

    public static void provideLang(BiConsumer<String, String> consumer) {
        for (DesiresKeys key : DesiresKeys.values()) {
            if (!key.modifiable) continue;
            consumer.accept(key.description, key.translation);
        }
    }

    @SubscribeEvent
    public static void register(RegisterKeyMappingsEvent event) {
        for (DesiresKeys key : DesiresKeys.values()) {
            key.keybind = new KeyMapping(key.description, key.key, "DnDesires");
            if (!key.modifiable) continue;
            event.register(key.keybind);
        }
    }

    public KeyMapping getKeybind() {
        return this.keybind;
    }

    public boolean isPressed() {
        if (!this.modifiable) {
            return DesiresKeys.isKeyDown(this.key);
        }
        return this.keybind.isDown();
    }

    public String getBoundKey() {
        return this.keybind.getTranslatedKeyMessage().getString().toUpperCase();
    }

    public boolean doesModifierAndCodeMatch(int code) {
        boolean codeMatches = code == this.keybind.getKey().getValue();
        KeyModifier modifier = this.keybind.getKeyModifier();
        boolean modifierMatches = modifier == KeyModifier.NONE ? true : KeyModifier.getActiveModifiers().contains(modifier);
        return codeMatches && modifierMatches;
    }

    public static boolean isKeyDown(int key) {
        return InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)key);
    }

    public static boolean isMouseButtonDown(int button) {
        return GLFW.glfwGetMouseButton((long)Minecraft.getInstance().getWindow().getWindow(), (int)button) == 1;
    }

    public static boolean ctrlDown() {
        return Screen.hasControlDown();
    }

    public static boolean shiftDown() {
        return Screen.hasShiftDown();
    }

    public static boolean altDown() {
        return Screen.hasAltDown();
    }
}

