/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndesires.content.items;

import com.simibubi.create.content.kinetics.saw.TreeCutter;
import com.simibubi.create.foundation.utility.AbstractBlockBreakQueue;
import com.simibubi.create.foundation.utility.BlockHelper;
import dev.lopyluna.dndesires.mixins.TreeAccessor;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;

public class TreeOverride
extends AbstractBlockBreakQueue {
    public final List<BlockPos> logs;
    public final List<BlockPos> leaves;
    public final List<BlockPos> attachments;

    public TreeOverride(TreeCutter.Tree tree) {
        this.logs = ((TreeAccessor)tree).logs();
        this.leaves = ((TreeAccessor)tree).leaves();
        this.attachments = ((TreeAccessor)tree).attachments();
    }

    public void destroyBlocks(Level level, ItemStack toDamage, Player player, BiConsumer<BlockPos, ItemStack> drop) {
        if (player == null) {
            return;
        }
        ItemStack dummy = toDamage.copy();
        dummy.set(DataComponents.UNBREAKABLE, (Object)new Unbreakable(false));
        this.attachments.forEach(this.makeCallbackFor(level, 0.03125f, toDamage, player, drop));
        this.logs.forEach(this.makeCallbackFor(level, 0.5f, toDamage, player, drop));
        this.leaves.forEach(this.makeCallbackFor(level, 0.125f, dummy, player, drop));
        int i = this.attachments.size() + this.logs.size() + this.leaves.size();
        player.causeFoodExhaustion((float)i * 0.5f);
    }

    protected Consumer<BlockPos> makeCallbackFor(Level level, float effectChance, ItemStack toDamage, Player player, BiConsumer<BlockPos, ItemStack> drop) {
        return pos -> {
            ItemStack usedTool = toDamage.copy();
            BlockHelper.destroyBlockAs((Level)level, (BlockPos)pos, (Player)player, (ItemStack)toDamage, (float)effectChance, stack -> drop.accept((BlockPos)pos, (ItemStack)stack));
            if (toDamage.isEmpty() && !usedTool.isEmpty()) {
                EventHooks.onPlayerDestroyItem((Player)player, (ItemStack)usedTool, (InteractionHand)InteractionHand.MAIN_HAND);
            }
        };
    }
}

