/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndesires.content.blocks.kinetics.stirling_engine.flywheel;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.flywheel.FlywheelBlock;
import com.simibubi.create.content.kinetics.simpleRelays.AbstractShaftBlock;
import dev.lopyluna.dndesires.content.blocks.kinetics.stirling_engine.StirlingEngineBlock;
import dev.lopyluna.dndesires.register.DesiresBETypes;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class PoweredFlywheelBlock
extends AbstractShaftBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;

    public PoweredFlywheelBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{FACING}));
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)super.rotate(state, rot).setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face == ((Direction)state.getValue((Property)FACING)).getOpposite();
    }

    @NotNull
    protected BlockState mirror(BlockState state, Mirror mirror) {
        return super.mirror(state, mirror).rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return AllBlocks.FLYWHEEL.asStack();
    }

    public void simpleTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, Direction pDirection, Direction.Axis pAxis) {
        if (pAxis != pDirection.getAxis()) {
            pState.setValue((Property)AXIS, (Comparable)pDirection.getAxis());
        }
        if (!PoweredFlywheelBlock.stillValid(pState, (LevelReader)pLevel, pPos)) {
            pLevel.setBlock(pPos, (BlockState)AllBlocks.FLYWHEEL.getDefaultState().setValue((Property)FlywheelBlock.AXIS, (Comparable)pAxis), 3);
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = this.getPreferredHorizontalFacing(context);
        BlockState state = this.defaultBlockState();
        if (direction != null) {
            ((BlockState)state.setValue((Property)FACING, (Comparable)direction)).setValue((Property)AXIS, (Comparable)direction.getAxis());
        }
        return this.withWater(state, context);
    }

    public Direction getPreferredHorizontalFacing(BlockPlaceContext context) {
        Direction preferSide = null;
        for (Direction side : Iterate.horizontalDirections) {
            BlockState blockState = context.getLevel().getBlockState(context.getClickedPos().relative(side));
            if (!(blockState.getBlock() instanceof IRotate) || !((IRotate)blockState.getBlock()).hasShaftTowards((LevelReader)context.getLevel(), context.getClickedPos().relative(side), blockState, side.getOpposite())) continue;
            if (preferSide != null && preferSide.getAxis() != side.getAxis()) {
                preferSide = null;
                break;
            }
            preferSide = side;
        }
        return preferSide;
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return PoweredFlywheelBlock.stillValid(pState, pLevel, pPos);
    }

    public static boolean stillValid(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        for (Direction d : Iterate.directions) {
            BlockPos enginePos;
            BlockState engineState;
            if (d.getAxis() == pState.getValue((Property)AXIS) || !((engineState = pLevel.getBlockState(enginePos = pPos.relative(d, 2))).getBlock() instanceof StirlingEngineBlock) || !StirlingEngineBlock.getFlywheelPos(engineState, enginePos).equals((Object)pPos) || !StirlingEngineBlock.isFlywheelValid(engineState, pState)) continue;
            return true;
        }
        return false;
    }

    public BlockEntityType<? extends KineticBlockEntity> getBlockEntityType() {
        return (BlockEntityType)DesiresBETypes.POWERED_FLYWHEEL.get();
    }
}

