/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.creeperoverhaul.common.registry;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import tech.thatgravyboat.creeperoverhaul.common.config.SpawningConfig;
import tech.thatgravyboat.creeperoverhaul.common.entity.CreeperTypes;
import tech.thatgravyboat.creeperoverhaul.common.entity.base.CreeperType;
import tech.thatgravyboat.creeperoverhaul.common.registry.ModEntities;

public class ModSpawns {
    public static void addSpawnRules(Registrar registrar) {
        registrar.register(ModEntities.JUNGLE_CREEPER, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, ModSpawns.getPredicate(CreeperTypes.JUNGLE, ModSpawns::checkMonsterSpawnRulesAbove));
        registrar.register(ModEntities.BAMBOO_CREEPER, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, ModSpawns.getPredicate(CreeperTypes.BAMBOO, ModSpawns::checkDayMonsterSpawnRulesAbove));
        registrar.register(ModEntities.DESERT_CREEPER, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ModSpawns.getPredicate(CreeperTypes.DESERT, ModSpawns::checkMonsterSpawnRulesAbove));
        registrar.register(ModEntities.BADLANDS_CREEPER, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ModSpawns.getPredicate(CreeperTypes.BADLANDS, ModSpawns::checkMonsterSpawnRulesAbove));
        registrar.register(ModEntities.HILLS_CREEPER, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ModSpawns.getPredicate(CreeperTypes.HILLS, ModSpawns::checkMonsterSpawnRulesAbove));
        registrar.register(ModEntities.SAVANNAH_CREEPER, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ModSpawns.getPredicate(CreeperTypes.SAVANNAH, ModSpawns::checkMonsterSpawnRulesAbove));
        registrar.register(ModEntities.MUSHROOM_CREEPER, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ModSpawns.getPredicate(CreeperTypes.MUSHROOM, ModSpawns::checkDayMonsterSpawnRulesAbove));
        registrar.register(ModEntities.SWAMP_CREEPER, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ModSpawns.getPredicate(CreeperTypes.SWAMP, ModSpawns::checkMonsterSpawnRulesAbove));
        registrar.register(ModEntities.DRIPSTONE_CREEPER, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ModSpawns.getPredicate(CreeperTypes.DRIPSTONE, ModSpawns::checkMonsterSpawnRulesCave));
        registrar.register(ModEntities.CAVE_CREEPER, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ModSpawns.getPredicate(CreeperTypes.CAVE, ModSpawns::checkMonsterSpawnRulesCave));
        registrar.register(ModEntities.DARK_OAK_CREEPER, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ModSpawns.getPredicate(CreeperTypes.DARK_OAK, ModSpawns::checkMonsterSpawnRulesAbove));
        registrar.register(ModEntities.SPRUCE_CREEPER, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ModSpawns.getPredicate(CreeperTypes.SPRUCE, ModSpawns::checkMonsterSpawnRulesAbove));
        registrar.register(ModEntities.BEACH_CREEPER, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ModSpawns.getPredicate(CreeperTypes.BEACH, ModSpawns::checkMonsterSpawnRulesAbove));
        registrar.register(ModEntities.SNOWY_CREEPER, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ModSpawns.getPredicate(CreeperTypes.SNOWY, ModSpawns::checkDayMonsterSpawnRulesAbove));
        registrar.register(ModEntities.OCEAN_CREEPER, SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ModSpawns.getPredicate(CreeperTypes.OCEAN, ModSpawns::checkWaterSpawnRules));
        registrar.register(ModEntities.BIRCH_CREEPER, SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ModSpawns.getPredicate(CreeperTypes.BIRCH, ModSpawns::checkMonsterSpawnRulesAbove));
    }

    public static <T extends Mob> SpawnPlacements.SpawnPredicate<T> getPredicate(CreeperType creeper, SpawnPlacements.SpawnPredicate<T> predicate) {
        return (type, level, reason, pos, random) -> creeper.canSpawn().getAsBoolean() && SpawningConfig.allowSpawning && predicate.test(type, level, reason, pos, random);
    }

    public static boolean checkMonsterSpawnRulesCave(EntityType<? extends Monster> pType, ServerLevelAccessor pLevel, MobSpawnType pReason, BlockPos pPos, RandomSource pRandom) {
        return pPos.getY() < pLevel.getSeaLevel() && !pLevel.getBlockState(pPos.below()).is(Blocks.GRASS_BLOCK) && pLevel.getDifficulty() != Difficulty.PEACEFUL && Monster.isDarkEnoughToSpawn((ServerLevelAccessor)pLevel, (BlockPos)pPos, (RandomSource)pRandom) && Monster.checkMobSpawnRules(pType, (LevelAccessor)pLevel, (MobSpawnType)pReason, (BlockPos)pPos, (RandomSource)pRandom);
    }

    public static boolean checkMonsterSpawnRulesAbove(EntityType<? extends Monster> pType, ServerLevelAccessor pLevel, MobSpawnType pReason, BlockPos pPos, RandomSource pRandom) {
        return pPos.getY() > pLevel.getSeaLevel() && pLevel.getDifficulty() != Difficulty.PEACEFUL && Monster.isDarkEnoughToSpawn((ServerLevelAccessor)pLevel, (BlockPos)pPos, (RandomSource)pRandom) && Monster.checkMobSpawnRules(pType, (LevelAccessor)pLevel, (MobSpawnType)pReason, (BlockPos)pPos, (RandomSource)pRandom);
    }

    public static boolean checkWaterSpawnRules(EntityType<? extends Monster> pType, ServerLevelAccessor pLevel, MobSpawnType pReason, BlockPos pPos, RandomSource pRandom) {
        int i = pLevel.getSeaLevel();
        int j = i - 13;
        return pPos.getY() >= j && pPos.getY() <= i && pLevel.getFluidState(pPos.below()).is(FluidTags.WATER) && pLevel.getBlockState(pPos.above()).is(Blocks.WATER);
    }

    public static boolean checkDayMonsterSpawnRulesAbove(EntityType<? extends Monster> pType, ServerLevelAccessor pLevel, MobSpawnType pReason, BlockPos pPos, RandomSource pRandom) {
        BlockState state = pLevel.getBlockState(pPos.below());
        boolean isGrassLike = state.is(Blocks.GRASS_BLOCK) || state.is(Blocks.PODZOL) || state.is(Blocks.MYCELIUM) || state.is(BlockTags.DIRT);
        return pPos.getY() > pLevel.getSeaLevel() && pLevel.getDifficulty() != Difficulty.PEACEFUL && Monster.checkMobSpawnRules(pType, (LevelAccessor)pLevel, (MobSpawnType)pReason, (BlockPos)pPos, (RandomSource)pRandom) && (isGrassLike || state.getBlock() instanceof LeavesBlock);
    }

    public static interface Registrar {
        public <T extends Mob> void register(Supplier<EntityType<T>> var1, SpawnPlacementType var2, Heightmap.Types var3, SpawnPlacements.SpawnPredicate<T> var4);
    }
}

