/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createcasing.blockEntities;

import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.motor.KineticScrollValueBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import fr.iglee42.createcasing.blocks.CreativeCogwheelBlock;
import fr.iglee42.createcasing.registries.EncasedBlocks;
import java.util.List;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class CreativeCogwheelBlockEntity
extends GeneratingKineticBlockEntity {
    public static final int DEFAULT_SPEED = 16;
    public static final int MAX_SPEED = 256;
    protected ScrollValueBehaviour generatedSpeed;

    public CreativeCogwheelBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        int max = 256;
        this.generatedSpeed = new KineticScrollValueBehaviour((Component)CreateLang.translateDirect((String)"kinetics.creative_motor.rotation_speed", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new CogwheelValueBox(this));
        this.generatedSpeed.between(-max, max);
        this.generatedSpeed.value = 16;
        this.generatedSpeed.withCallback(i -> this.updateGeneratedRotation());
        behaviours.add((BlockEntityBehaviour)this.generatedSpeed);
    }

    public List<BlockPos> addPropagationLocations(IRotate block, BlockState state, List<BlockPos> neighbours) {
        return super.addPropagationLocations(block, state, neighbours);
    }

    public void initialize() {
        super.initialize();
        if (!this.hasSource() || this.getGeneratedSpeed() > this.getTheoreticalSpeed()) {
            this.updateGeneratedRotation();
        }
    }

    public float getGeneratedSpeed() {
        if (!EncasedBlocks.CREATIVE_COGWHEEL.has(this.getBlockState())) {
            return 0.0f;
        }
        return this.generatedSpeed.getValue();
    }

    class CogwheelValueBox
    extends ValueBoxTransform.Sided {
        CogwheelValueBox(CreativeCogwheelBlockEntity this$0) {
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)15.5);
        }

        protected boolean isSideActive(BlockState state, Direction direction) {
            return state.getValue((Property)CreativeCogwheelBlock.AXIS) == direction.getAxis();
        }
    }
}

