/*
 * Decompiled with CFR 0.152.
 */
package snownee.companion.mixin;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import net.minecraft.core.BlockPos;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import snownee.companion.CompanionCommonConfig;
import snownee.companion.CompanionTamableAnimal;
import snownee.companion.Hooks;
import snownee.companion.mixin.TamableAnimalAccess;

@Mixin(value={TamableAnimal.class})
public abstract class TamableAnimalMixin
extends Animal
implements CompanionTamableAnimal,
OwnableEntity {
    @Unique
    private long companion$lastTeleportation = Long.MIN_VALUE;

    protected TamableAnimalMixin(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public void companion$tryTeleportToOwner(DamageSource damageSource) {
        if (!Hooks.isInjured((LivingEntity)this)) {
            return;
        }
        LivingEntity owner = this.getOwner();
        if (owner == null) {
            return;
        }
        Hooks.stopAttacking((Mob)this);
        Entity entity = damageSource.getEntity();
        if (entity instanceof Mob) {
            Mob attacker = (Mob)entity;
            Hooks.stopAttacking(attacker);
        }
        if (owner == damageSource.getEntity() || !Hooks.shouldFollowOwner(owner, (Mob)this)) {
            return;
        }
        long time = this.level().getGameTime();
        long interval = time - this.companion$lastTeleportation;
        if (interval > 0L && interval < 600L) {
            return;
        }
        this.companion$lastTeleportation = time;
        ((TamableAnimalAccess)((Object)this)).callTeleportToAroundBlockPos(owner.blockPosition().relative(owner.getDirection().getOpposite(), 3));
    }

    @WrapMethod(method={"teleportToAroundBlockPos"})
    private void companion_teleportToAroundBlockPos(BlockPos pos, Operation<Void> original) {
        if (!CompanionCommonConfig.petForceTeleportingIfFollowFailed) {
            original.call(new Object[]{pos});
            return;
        }
        Hooks.teleportWithRandomOffset((Mob)this, this.level(), pos, null, (Entity)this.getOwner()).ifPresent(vec -> this.teleportTo(vec.x, vec.y, vec.z));
    }
}

