/*
 * Decompiled with CFR 0.152.
 */
package snownee.companion.mixin;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import snownee.companion.Companion;
import snownee.companion.CompanionCommonConfig;
import snownee.companion.CompanionPlayer;
import snownee.companion.Hooks;

@Mixin(value={Player.class}, priority=1050)
public abstract class PlayerMixin
implements CompanionPlayer {
    @Unique
    private Vec3 companion$jumpPos;

    @Inject(at={@At(value="TAIL")}, method={"aiStep"})
    private void companion_aiStep(CallbackInfo ci) {
        Player player = (Player)this;
        if (player.level().isClientSide) {
            return;
        }
        if (player.isSleeping() || player.isInPowderSnow) {
            this.removeEntitiesOnShoulder();
            return;
        }
        if (CompanionCommonConfig.shoulderDismountInWater && player.isInWater()) {
            this.removeEntitiesOnShoulder();
            return;
        }
        if (CompanionCommonConfig.shoulderDismountUnderWater && player.isUnderWater()) {
            this.removeEntitiesOnShoulder();
            return;
        }
        if (player.fallDistance > CompanionCommonConfig.shoulderDismountFallDistance) {
            this.removeEntitiesOnShoulder();
            return;
        }
        if (CompanionCommonConfig.shoulderDismountWhileFlying && player.getAbilities().flying) {
            this.removeEntitiesOnShoulder();
            return;
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"hurt"})
    private void companion_hurt(DamageSource damageSource, float f, CallbackInfoReturnable<Boolean> ci) {
        if (f > CompanionCommonConfig.shoulderDismountDamageThreshold) {
            this.removeEntitiesOnShoulder();
        }
    }

    @Shadow
    protected abstract void removeEntitiesOnShoulder();

    @Override
    public Vec3 companion$getJumpPos() {
        return this.companion$jumpPos;
    }

    @Override
    public void companion$setJumpPos(Vec3 pos) {
        this.companion$jumpPos = pos;
    }

    @Override
    public void companion$removeShoulderEntities() {
        this.removeEntitiesOnShoulder();
    }

    @Inject(at={@At(value="HEAD")}, method={"jumpFromGround"})
    private void companion_jumpFromGround(CallbackInfo ci) {
        this.companion$jumpPos = ((Player)this).position();
    }

    @Inject(at={@At(value="HEAD")}, method={"attack"}, cancellable=true)
    private void companion_attack(Entity entity, CallbackInfo ci) {
        Player self;
        if (Hooks.getEntityOwner(entity) == this && !(self = (Player)this).level().getGameRules().getBoolean(Companion.PET_FRIENDLY_FIRE)) {
            ci.cancel();
        }
    }
}

