/*
 * Decompiled with CFR 0.152.
 */
package snownee.companion.mixin;

import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import snownee.companion.Companion;
import snownee.companion.CompanionCommonConfig;
import snownee.companion.CompanionPlayer;
import snownee.companion.Hooks;

@Mixin(value={Entity.class})
public class EntityMixin {
    @Inject(at={@At(value="HEAD")}, method={"checkFallDamage"})
    private void companion_checkFallDamage(double d, boolean bl, BlockState blockState, BlockPos blockPos, CallbackInfo ci) {
        Entity entity = (Entity)this;
        if (bl && CompanionCommonConfig.shoulderDismountSmartMode && !entity.level().isClientSide && entity.fallDistance > 0.0f && entity instanceof Player) {
            CompanionPlayer player = (CompanionPlayer)((Object)this);
            Vec3 past = player.companion$getJumpPos();
            if (past == null) {
                return;
            }
            Vec3 now = entity.position();
            player.companion$setJumpPos(null);
            if (Mth.equal((double)past.x, (double)now.x) && Mth.equal((double)past.y, (double)now.y) && Mth.equal((double)past.z, (double)now.z)) {
                player.companion$removeShoulderEntities();
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"canChangeDimensions"}, cancellable=true)
    private void companion_canChangeDimensions(CallbackInfoReturnable<Boolean> ci) {
        Player owner;
        if (Hooks.traveling) {
            return;
        }
        float r = CompanionCommonConfig.petWontChangeDimensionUnlessOwnerIsNearbyRadius;
        if (r < 0.0f) {
            return;
        }
        Entity entity = (Entity)this;
        UUID ownerUUID = Hooks.getEntityOwnerUUID(entity);
        if (ownerUUID != null && ((owner = entity.level().getPlayerByUUID(ownerUUID)) == null || owner.distanceToSqr(entity) > (double)(r * r))) {
            ci.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"isAlliedTo(Lnet/minecraft/world/entity/Entity;)Z"}, cancellable=true)
    private void companion_isAlliedTo(Entity entity, CallbackInfoReturnable<Boolean> ci) {
        Player owner;
        Player player;
        EntityMixin entityMixin;
        if (CompanionCommonConfig.betterSweepingEdgeEffect && (entityMixin = this) instanceof Player && Objects.equals(player = (Player)entityMixin, owner = Hooks.getEntityOwner(entity))) {
            ci.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"isInvulnerableTo"}, cancellable=true)
    private void companion_isInvulnerableTo(DamageSource damageSource, CallbackInfoReturnable<Boolean> ci) {
        Entity self = (Entity)this;
        if (!damageSource.is(DamageTypes.PLAYER_EXPLOSION) && damageSource.getEntity() != null && Hooks.getEntityOwner(self) == damageSource.getEntity() && !self.level().getGameRules().getBoolean(Companion.PET_FRIENDLY_FIRE)) {
            ci.setReturnValue((Object)true);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"isInvulnerable"}, cancellable=true)
    private void companion_isInvulnerable(CallbackInfoReturnable<Boolean> cir) {
        LivingEntity self;
        EntityMixin entityMixin = this;
        if (entityMixin instanceof LivingEntity && Hooks.isImmortalDying(self = (LivingEntity)entityMixin)) {
            cir.setReturnValue((Object)true);
        }
    }
}

