/*
 * Decompiled with CFR 0.152.
 */
package snownee.companion;

import com.google.common.collect.Lists;
import com.lizin5ths.indypets.util.Independence;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import snownee.companion.CommonProxy;
import snownee.companion.Companion;
import snownee.companion.CompanionCommonConfig;
import snownee.companion.mixin.MobAccess;
import snownee.companion.mixin.TamableAnimalAccess;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.util.NotNullByDefault;

@NotNullByDefault
public class Hooks {
    public static final TagKey<Item> CHARGED_RANGED_WEAPONS = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"companion", (String)"charged_ranged_weapons"));
    public static final Object2BooleanMap<Class<?>> FOLLOWABLE_CACHE = new Object2BooleanOpenHashMap();
    public static boolean traveling;
    public static boolean indyPets;

    public static void changeDimension(ServerPlayer player, ServerLevel to, ServerLevel from, boolean returnFromEnd) {
        if (player.isSpectator() || player.isDeadOrDying()) {
            return;
        }
        if (returnFromEnd ? player.level() != from : player.level() != to) {
            return;
        }
        boolean nether = from.dimension() == Level.NETHER || to.dimension() == Level.NETHER;
        BlockPos portalPos = null;
        if (nether) {
            if (player.portalProcess != null) {
                portalPos = player.portalProcess.getEntryPosition();
            }
            if (portalPos == null) {
                return;
            }
        }
        for (Entity entity : Hooks.getAllPets(from, to, player)) {
            if (nether) {
                entity.setPortalCooldown(0);
                entity.setAsInsidePortal((Portal)((NetherPortalBlock)Blocks.NETHER_PORTAL), portalPos);
            }
            if (!(entity instanceof Mob)) continue;
            Mob mob = (Mob)entity;
            entity.setPortalCooldown();
            Vec3 dest = Hooks.teleportWithRandomOffset(mob, (Level)to, player.blockPosition(), false, (Entity)player).orElseGet(() -> ((ServerPlayer)player).position());
            entity.changeDimension(new DimensionTransition(to, dest, Vec3.ZERO, 0.0f, 0.0f, DimensionTransition.DO_NOTHING));
        }
    }

    public static List<Entity> getAllPets(ServerLevel level, ServerLevel to, ServerPlayer player) {
        int max = CompanionCommonConfig.portalMaxTeleportedPets;
        if (max == -1) {
            max = level.getGameRules().getInt(GameRules.RULE_MAX_ENTITY_CRAMMING);
        }
        traveling = true;
        ArrayList entities = Lists.newArrayList();
        for (Entity entity : level.getAllEntities()) {
            if (entities.size() >= max) break;
            if (entity.isPassenger() || !entity.canChangeDimensions((Level)level, (Level)to) || !(entity instanceof Mob)) continue;
            Mob mob = (Mob)entity;
            if (mob.isLeashed()) {
                if (mob.getLeashHolder() != player) continue;
                entities.add(mob);
                continue;
            }
            if (!Objects.equals(player.getUUID(), Hooks.getEntityOwnerUUID((Entity)mob)) || !Hooks.shouldFollowOwner((LivingEntity)player, mob)) continue;
            entities.add(mob);
        }
        traveling = false;
        return entities;
    }

    public static Optional<Vec3> teleportWithRandomOffset(Mob entity, Level level, BlockPos blockPos, @Nullable Boolean canFly, @Nullable Entity avoidColliding) {
        AABB box;
        TamableAnimalAccess tamable;
        boolean _canFly = canFly != null ? canFly : entity instanceof FlyingAnimal || entity instanceof TamableAnimalAccess && (tamable = (TamableAnimalAccess)entity).callCanFlyToOwner();
        Optional<Vec3> vec3 = Hooks.teleportWithRandomOffsetInternal(entity, level, blockPos, _canFly, box = avoidColliding == null ? null : avoidColliding.getBoundingBox());
        if (vec3.isPresent() || _canFly) {
            return vec3;
        }
        BlockPos heightmapPos = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, blockPos);
        if (heightmapPos.getY() < blockPos.getY()) {
            return Hooks.teleportWithRandomOffsetInternal(entity, level, heightmapPos, false, box);
        }
        BlockPos.MutableBlockPos mutable = blockPos.mutable().move(Direction.DOWN);
        for (int i = 0; i < 25; ++i) {
            mutable.move(Direction.DOWN);
            BlockState blockState = level.getBlockState((BlockPos)mutable);
            if (!Heightmap.Types.MOTION_BLOCKING.isOpaque().test(blockState)) continue;
            return Hooks.teleportWithRandomOffsetInternal(entity, level, (BlockPos)mutable, false, box);
        }
        return Optional.empty();
    }

    private static Optional<Vec3> teleportWithRandomOffsetInternal(Mob entity, Level level, BlockPos blockPos, boolean canFly, @Nullable AABB avoidColliding) {
        if (entity.level() == level && blockPos.distToCenterSqr((Position)entity.position()) < 16.0) {
            return Optional.empty();
        }
        RandomSource random = entity.getRandom();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 25; ++i) {
            int j = Hooks.randomIntInclusive(random, -3, 3);
            int l = Hooks.randomIntInclusive(random, -3, 3);
            if (Math.abs(j) + Math.abs(l) < 2) continue;
            int k = Hooks.randomIntInclusive(random, -1, 1);
            pos.set(blockPos.getX() + j, blockPos.getY() + k, blockPos.getZ() + l);
            if (!Hooks.canTeleportTo(entity, level, (BlockPos)pos, canFly, avoidColliding)) continue;
            return Optional.of(new Vec3((double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5));
        }
        return Optional.empty();
    }

    private static int randomIntInclusive(RandomSource random, int i, int j) {
        return random.nextInt(j - i + 1) + i;
    }

    private static boolean canTeleportTo(Mob entity, Level level, BlockPos blockPos, boolean canFly, @Nullable AABB avoidColliding) {
        PathfindingContext pathfindingContext = new PathfindingContext((CollisionGetter)level, entity);
        BlockPos.MutableBlockPos mutable = blockPos.mutable();
        PathType blockPathType = WalkNodeEvaluator.getPathTypeStatic((PathfindingContext)pathfindingContext, (BlockPos.MutableBlockPos)mutable);
        if (blockPathType == PathType.OPEN && !canFly) {
            return false;
        }
        if (entity instanceof PathfinderMob) {
            PathfinderMob pathfinderMob = (PathfinderMob)entity;
            float f = pathfinderMob.getWalkTargetValue(blockPos);
            if (blockPathType == PathType.WATER) {
                if (f > PathType.WATER.getMalus()) {
                    return false;
                }
                mutable.move(Direction.UP);
                BlockState aboveState = level.getBlockState((BlockPos)mutable);
                if (!aboveState.isAir()) {
                    return false;
                }
            } else if (blockPathType == PathType.LAVA || blockPathType == PathType.DAMAGE_FIRE || blockPathType == PathType.DANGER_FIRE ? !entity.fireImmune() : blockPathType != PathType.WALKABLE && blockPathType != PathType.OPEN) {
                return false;
            }
        } else if (blockPathType != PathType.WALKABLE && blockPathType != PathType.OPEN) {
            return false;
        }
        BlockPos blockPos2 = blockPos.subtract((Vec3i)entity.blockPosition());
        AABB moved = entity.getBoundingBox().move((double)blockPos2.getX() + 0.5, (double)blockPos2.getY(), (double)blockPos2.getZ() + 0.5);
        return !moved.intersects(avoidColliding) && level.noCollision((Entity)entity, moved);
    }

    public static boolean wantsToAttack(TamableAnimal pet, @Nullable LivingEntity enemy) {
        if (!pet.isTame()) {
            return true;
        }
        if (Hooks.isImmortalDying((LivingEntity)pet)) {
            return false;
        }
        if (CompanionCommonConfig.petWontAttackWhenInjured && Hooks.isInjured((LivingEntity)pet)) {
            return enemy != null && !(enemy instanceof Enemy) && !(enemy instanceof IronGolem);
        }
        return true;
    }

    public static boolean isImmortalDying(LivingEntity entity) {
        return !entity.isDeadOrDying() && entity.getHealth() <= 1.0f && entity.level().getGameRules().getBoolean(Companion.IMMORTAL_PETS) && Hooks.getEntityOwner((Entity)entity) != null;
    }

    public static boolean isInjured(LivingEntity entity) {
        return entity.getHealth() < entity.getMaxHealth() && entity.getHealth() / entity.getMaxHealth() <= CompanionCommonConfig.petInjuredStatusHealthRatio;
    }

    public static void handleChunkPreUnload(List<EntityAccess> entities) {
        for (EntityAccess entityAccess : entities) {
            Mob entity;
            Player owner;
            if (!(entityAccess instanceof Mob) || !Hooks.shouldFollowOwner((LivingEntity)(owner = Hooks.getEntityOwner((Entity)(entity = (Mob)entityAccess))), entity) || owner.level() != entity.level()) continue;
            BlockPos pos = owner.blockPosition();
            Hooks.teleportWithRandomOffset(entity, owner.level(), pos, null, (Entity)owner).ifPresentOrElse(vec -> entity.teleportTo(vec.x, vec.y, vec.z), () -> {
                if (!entity.randomTeleport((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), false) && CompanionCommonConfig.logIfTeleportingFailed) {
                    Companion.LOGGER.warn("Failed to teleport {}({}) from {} {} to {}", new Object[]{Objects.requireNonNull(entity.getDisplayName()).getString(), BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()), entity.level().dimension().location(), entity.blockPosition().toShortString(), pos.toShortString()});
                }
            });
        }
    }

    public static boolean shouldFollowOwner(@Nullable LivingEntity owner, Mob pet) {
        if (owner == null || owner.isDeadOrDying() || owner.isSpectator() || pet.isLeashed() || pet.isPassenger()) {
            return false;
        }
        if (pet instanceof TamableAnimal) {
            TamableAnimal animal = (TamableAnimal)pet;
            if (animal.isOrderedToSit()) {
                return false;
            }
            if (indyPets && ((Independence)animal).indypets$isIndependent()) {
                return false;
            }
        }
        if (pet instanceof AbstractHorse) {
            return pet.level().getGameRules().getBoolean(Companion.ALWAYS_TELEPORT_HORSES);
        }
        return FOLLOWABLE_CACHE.computeIfAbsent(pet.getClass(), $ -> {
            for (WrappedGoal goal : ((MobAccess)pet).getGoalSelector().getAvailableGoals()) {
                if (!(goal.getGoal() instanceof FollowOwnerGoal)) continue;
                return true;
            }
            return false;
        });
    }

    public static boolean isHoldingRangedWeapon(ServerPlayer player) {
        ItemStack stack;
        UseAnim anim;
        if (player.isHolding(CommonProxy::isRangedWeapon)) {
            ItemStack stack2;
            ItemStack main = player.getMainHandItem();
            ItemStack off = player.getOffhandItem();
            ItemStack itemStack = stack2 = CommonProxy.isRangedWeapon(main) ? main : off;
            if (stack2.getItem() instanceof CrossbowItem) {
                if (CrossbowItem.isCharged((ItemStack)stack2)) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return player.isUsingItem() && player.getUseItemRemainingTicks() > 0 && player.isHolding($ -> $.is(CHARGED_RANGED_WEAPONS)) && ((anim = (stack = player.getUseItem()).getUseAnimation()) == UseAnim.BOW || anim == UseAnim.CROSSBOW || anim == UseAnim.SPEAR);
    }

    @Nullable
    public static Player getEntityOwner(Entity entity) {
        UUID ownerUUID = Hooks.getEntityOwnerUUID(entity);
        if (ownerUUID == null) {
            return null;
        }
        MinecraftServer server = entity.level().getServer();
        if (server == null) {
            return entity.level().getPlayerByUUID(ownerUUID);
        }
        return server.getPlayerList().getPlayer(ownerUUID);
    }

    @Nullable
    public static UUID getEntityOwnerUUID(Entity entity) {
        if (entity instanceof OwnableEntity) {
            OwnableEntity ownableEntity = (OwnableEntity)entity;
            return ownableEntity.getOwnerUUID();
        }
        return null;
    }

    public static void stopAttacking(Mob mob) {
        mob.setTarget(null);
        for (WrappedGoal goal : mob.targetSelector.getAvailableGoals()) {
            goal.stop();
        }
        if (mob.getBrain().hasMemoryValue(MemoryModuleType.ATTACK_TARGET)) {
            mob.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
        }
    }

    static {
        indyPets = Platform.isModLoaded((String)"indypets");
    }
}

