/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.geforcemods.securitycraft.blockentities.ClaymoreBlockEntity;
import net.geforcemods.securitycraft.blocks.mines.ClaymoreBlock;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;

public class ClaymoreRenderer
implements BlockEntityRenderer<ClaymoreBlockEntity> {
    public ClaymoreRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(ClaymoreBlockEntity be, float partialTicks, PoseStack pose, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (((Boolean)be.getBlockState().getValue((Property)ClaymoreBlock.DEACTIVATED)).booleanValue()) {
            return;
        }
        Direction claymoreFacing = (Direction)be.getBlockState().getValue((Property)ClaymoreBlock.FACING);
        Direction rotationDirection = switch (claymoreFacing) {
            case Direction.EAST, Direction.WEST -> claymoreFacing.getOpposite();
            default -> claymoreFacing;
        };
        pose.pushPose();
        pose.translate(0.5, 0.0, 0.5);
        pose.mulPose(Axis.YP.rotationDegrees(rotationDirection.toYRot()));
        pose.translate(-0.5, 0.0, -0.5);
        VertexConsumer builder = buffer.getBuffer(RenderType.lines());
        Matrix4f positionMatrix = pose.last().pose();
        Vec3i normal = claymoreFacing.getNormal();
        float multiplier = 0.0625f;
        float xzStart = 9.0f * multiplier;
        float y = 4.5f * multiplier;
        ItemStack lens = be.getLensContainer().getItem(0);
        int r = 255;
        int g = 255;
        int b = 255;
        if (lens.has(DataComponents.DYED_COLOR)) {
            int color = ((DyedItemColor)lens.get(DataComponents.DYED_COLOR)).rgb();
            r = color >> 16 & 0xFF;
            g = color >> 8 & 0xFF;
            b = color & 0xFF;
        }
        builder.addVertex(positionMatrix, xzStart, y, xzStart).setColor(r, g, b, 255).setNormal((float)normal.getX(), (float)normal.getY(), (float)normal.getZ());
        builder.addVertex(positionMatrix, 11.0f * multiplier, y, 1.0f).setColor(r, g, b, 0).setNormal((float)normal.getX(), (float)normal.getY(), (float)normal.getZ());
        builder.addVertex(positionMatrix, 7.0f * multiplier, y, xzStart).setColor(r, g, b, 255).setNormal((float)normal.getX(), (float)normal.getY(), (float)normal.getZ());
        builder.addVertex(positionMatrix, 5.0f * multiplier, y, 1.0f).setColor(r, g, b, 0).setNormal((float)normal.getX(), (float)normal.getY(), (float)normal.getZ());
        pose.popPose();
    }

    public boolean shouldRenderOffScreen(ClaymoreBlockEntity be) {
        return true;
    }
}

