/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.recipe;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.components.KeycardData;
import net.geforcemods.securitycraft.items.KeycardItem;
import net.geforcemods.securitycraft.recipe.CombineRecipe;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class LimitedUseKeycardRecipe
extends CombineRecipe {
    public LimitedUseKeycardRecipe(CraftingBookCategory craftingBookCategory) {
        super(craftingBookCategory);
    }

    @Override
    public boolean matchesFirstItem(ItemStack stack) {
        return stack.getItem() instanceof KeycardItem && !this.matchesSecondItem(stack) && !((KeycardData)stack.getOrDefault(SCContent.KEYCARD_DATA, (Object)KeycardData.DEFAULT)).limited();
    }

    @Override
    public boolean matchesSecondItem(ItemStack stack) {
        return stack.is(SCContent.LIMITED_USE_KEYCARD);
    }

    @Override
    public ItemStack combine(ItemStack keycardToCopy, ItemStack limitedUseKeycard) {
        ItemStack outputKeycard = keycardToCopy.copy();
        outputKeycard.update(SCContent.KEYCARD_DATA, (Object)KeycardData.DEFAULT, data -> data.setLimitedAndUsesLeft(true, 0));
        outputKeycard.setCount(2);
        return outputKeycard;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)SCContent.LIMITED_USE_KEYCARD_RECIPE_SERIALIZER.get();
    }
}

