/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.FrameBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SyncFrame(BlockPos pos, int requestedRenderDistance, Optional<GlobalPos> removedCamera, Optional<GlobalPos> currentCamera, boolean disableCurrentCamera) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncFrame> TYPE = new CustomPacketPayload.Type(SecurityCraft.resLoc("sync_frame"));
    public static final StreamCodec<ByteBuf, SyncFrame> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, SyncFrame::pos, (StreamCodec)ByteBufCodecs.VAR_INT, SyncFrame::requestedRenderDistance, (StreamCodec)ByteBufCodecs.optional((StreamCodec)GlobalPos.STREAM_CODEC), SyncFrame::removedCamera, (StreamCodec)ByteBufCodecs.optional((StreamCodec)GlobalPos.STREAM_CODEC), SyncFrame::currentCamera, (StreamCodec)ByteBufCodecs.BOOL, SyncFrame::disableCurrentCamera, SyncFrame::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        BlockEntity blockEntity;
        Player player = ctx.player();
        Level level = player.level();
        GlobalPos currentCamera = this.currentCamera.orElse(null);
        if (!player.isSpectator() && (blockEntity = level.getBlockEntity(this.pos)) instanceof FrameBlockEntity) {
            FrameBlockEntity be = (FrameBlockEntity)blockEntity;
            if (be.isDisabled()) {
                return;
            }
            boolean isOwner = be.isOwnedBy((Entity)player);
            if (isOwner) {
                this.removedCamera.ifPresent(be::removeCamera);
            }
            if (isOwner || be.isAllowed((Entity)player)) {
                be.switchCameras(currentCamera, player, this.requestedRenderDistance, this.disableCurrentCamera);
            }
        }
    }
}

