/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.List;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.DisplayCaseBlockEntity;
import net.geforcemods.securitycraft.components.OwnerData;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;

public class AdminToolItem
extends Item {
    public AdminToolItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext ctx) {
        Level level = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        Player player = ctx.getPlayer();
        MutableComponent adminToolName = Utils.localize(this.getDescriptionId(), new Object[0]);
        if (((Boolean)ConfigHandler.SERVER.allowAdminTool.get()).booleanValue()) {
            if (!player.isCreative()) {
                PlayerUtils.sendMessageToPlayer(player, adminToolName, Utils.localize("messages.securitycraft:adminTool.needCreative", new Object[0]), ChatFormatting.DARK_PURPLE);
                return InteractionResult.FAIL;
            }
            InteractionResult briefcaseResult = this.handleBriefcase(player, ctx.getHand()).getResult();
            if (briefcaseResult != InteractionResult.PASS) {
                return briefcaseResult;
            }
            BlockEntity be = level.getBlockEntity(pos);
            if (be != null) {
                IModuleInventory inv;
                List<ModuleType> modules;
                DisplayCaseBlockEntity displayCase;
                if (be instanceof DisplayCaseBlockEntity && (displayCase = (DisplayCaseBlockEntity)be).isOpen() && displayCase.getDisplayedStack().isEmpty()) {
                    return InteractionResult.PASS;
                }
                boolean hasInfo = false;
                boolean isOwnable = be instanceof IOwnable;
                if (isOwnable) {
                    Owner owner = ((IOwnable)be).getOwner();
                    PlayerUtils.sendMessageToPlayer(player, adminToolName, Utils.localize("messages.securitycraft:adminTool.owner.name", owner.getName() == null ? "????" : owner.getName()), ChatFormatting.DARK_PURPLE);
                    PlayerUtils.sendMessageToPlayer(player, adminToolName, Utils.localize("messages.securitycraft:adminTool.owner.uuid", owner.getUUID() == null ? "????" : owner.getUUID()), ChatFormatting.DARK_PURPLE);
                    hasInfo = true;
                }
                if (be instanceof IModuleInventory && !(modules = (inv = (IModuleInventory)be).getInsertedModules()).isEmpty()) {
                    PlayerUtils.sendMessageToPlayer(player, adminToolName, Utils.localize("messages.securitycraft:adminTool.equippedModules", new Object[0]), ChatFormatting.DARK_PURPLE);
                    for (ModuleType module : modules) {
                        PlayerUtils.sendMessageToPlayer(player, adminToolName, Component.literal((String)"- ").append((Component)Component.translatable((String)module.getTranslationKey())), ChatFormatting.DARK_PURPLE);
                    }
                    hasInfo = true;
                }
                if (isOwnable && be instanceof SignBlockEntity) {
                    SignBlockEntity signBe = (SignBlockEntity)be;
                    PlayerUtils.sendMessageToPlayer(player, adminToolName, Component.literal((String)""), ChatFormatting.DARK_PURPLE);
                    PlayerUtils.sendMessageToPlayer(player, adminToolName, Utils.localize("messages.securitycraft:adminTool.signFrontText", new Object[0]), ChatFormatting.DARK_PURPLE);
                    this.sendSignText(signBe.getFrontText(), player, adminToolName);
                    PlayerUtils.sendMessageToPlayer(player, adminToolName, Component.literal((String)""), ChatFormatting.DARK_PURPLE);
                    PlayerUtils.sendMessageToPlayer(player, adminToolName, Utils.localize("messages.securitycraft:adminTool.signBackText", new Object[0]), ChatFormatting.DARK_PURPLE);
                    this.sendSignText(signBe.getBackText(), player, adminToolName);
                    hasInfo = true;
                }
                if (!hasInfo) {
                    PlayerUtils.sendMessageToPlayer(player, adminToolName, Utils.localize("messages.securitycraft:adminTool.noInfo", new Object[0]), ChatFormatting.DARK_PURPLE);
                }
                return InteractionResult.SUCCESS;
            }
            PlayerUtils.sendMessageToPlayer(player, adminToolName, Utils.localize("messages.securitycraft:adminTool.noInfo", new Object[0]), ChatFormatting.DARK_PURPLE);
        } else {
            PlayerUtils.sendMessageToPlayer(player, adminToolName, Utils.localize("messages.securitycraft:adminTool.disabled", new Object[0]), ChatFormatting.DARK_PURPLE);
        }
        return InteractionResult.FAIL;
    }

    private void sendSignText(SignText signText, Player player, MutableComponent adminToolName) {
        for (int i = 0; i < 4; ++i) {
            Component text = signText.getMessage(i, false);
            if (!(text instanceof MutableComponent)) continue;
            MutableComponent mutableComponent = (MutableComponent)text;
            PlayerUtils.sendMessageToPlayer(player, adminToolName, mutableComponent, ChatFormatting.DARK_PURPLE);
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (!player.isCreative()) {
            PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:adminTool.needCreative", new Object[0]), ChatFormatting.DARK_PURPLE);
            return InteractionResultHolder.fail((Object)player.getItemInHand(hand));
        }
        return this.handleBriefcase(player, hand);
    }

    private InteractionResultHolder<ItemStack> handleBriefcase(Player player, InteractionHand hand) {
        ItemStack adminTool = player.getItemInHand(hand);
        if (hand == InteractionHand.MAIN_HAND && player.getOffhandItem().getItem() == SCContent.BRIEFCASE.get()) {
            ItemStack briefcase = player.getOffhandItem();
            MutableComponent adminToolName = Utils.localize(this.getDescriptionId(), new Object[0]);
            OwnerData ownerData = (OwnerData)briefcase.getOrDefault(SCContent.OWNER_DATA, (Object)OwnerData.DEFAULT);
            String ownerName = ownerData.name();
            String ownerUUID = ownerData.uuid();
            PlayerUtils.sendMessageToPlayer(player, adminToolName, Utils.localize("messages.securitycraft:adminTool.owner.name", ownerName.isEmpty() ? "????" : ownerName), ChatFormatting.DARK_PURPLE);
            PlayerUtils.sendMessageToPlayer(player, adminToolName, Utils.localize("messages.securitycraft:adminTool.owner.uuid", ownerUUID.isEmpty() ? "????" : ownerUUID), ChatFormatting.DARK_PURPLE);
            return InteractionResultHolder.success((Object)adminTool);
        }
        return InteractionResultHolder.pass((Object)adminTool);
    }
}

