/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity.camera;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.function.Consumer;
import net.geforcemods.securitycraft.SecurityCraftClient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.ChunkEvent;

public class CameraClientChunkCacheExtension {
    private static final Long2ObjectOpenHashMap<LevelChunk> CHUNK_MAP = new Long2ObjectOpenHashMap();
    private static final Long2ObjectOpenHashMap<LevelChunk> CHUNK_MAP_OTHER_THREADS = new Long2ObjectOpenHashMap();

    private CameraClientChunkCacheExtension() {
    }

    public static void drop(ClientLevel level, ChunkPos chunkPos) {
        long chunkPosLong;
        LevelChunk chunk;
        if (Minecraft.getInstance().isSameThread() && (chunk = (LevelChunk)CHUNK_MAP.get(chunkPosLong = chunkPos.toLong())) != null) {
            CameraClientChunkCacheExtension.modifyChunkMaps(map -> map.remove(chunkPosLong));
            NeoForge.EVENT_BUS.post((Event)new ChunkEvent.Unload((ChunkAccess)chunk));
            level.unload(chunk);
            SecurityCraftClient.INSTALLED_IUM_MOD.onChunkStatusRemoved(level, chunkPos.x, chunkPos.z);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LevelChunk getChunk(int x, int z) {
        long chunkPos = ChunkPos.asLong((int)x, (int)z);
        if (Minecraft.getInstance().isSameThread()) {
            return (LevelChunk)CHUNK_MAP.get(chunkPos);
        }
        Long2ObjectOpenHashMap<LevelChunk> long2ObjectOpenHashMap = CHUNK_MAP_OTHER_THREADS;
        synchronized (long2ObjectOpenHashMap) {
            return (LevelChunk)CHUNK_MAP_OTHER_THREADS.get(chunkPos);
        }
    }

    public static LevelChunk replaceWithPacketData(ClientLevel level, int x, int z, FriendlyByteBuf packetData, CompoundTag chunkTag, Consumer<ClientboundLevelChunkPacketData.BlockEntityTagOutput> tagOutput) {
        if (!Minecraft.getInstance().isSameThread()) {
            throw new UnsupportedOperationException("replaceWithPacketData called off-thread, this shouldn't happen!");
        }
        ChunkPos chunkPos = new ChunkPos(x, z);
        long longChunkPos = chunkPos.toLong();
        LevelChunk chunk = (LevelChunk)CHUNK_MAP.get(longChunkPos);
        if (chunk == null) {
            LevelChunk newChunk;
            chunk = newChunk = new LevelChunk((Level)level, chunkPos);
            chunk.replaceWithPacketData(packetData, chunkTag, tagOutput);
            CameraClientChunkCacheExtension.modifyChunkMaps(map -> map.put(longChunkPos, (Object)newChunk));
        }
        level.onChunkLoaded(chunkPos);
        SecurityCraftClient.INSTALLED_IUM_MOD.onChunkStatusAdded(level, x, z);
        NeoForge.EVENT_BUS.post((Event)new ChunkEvent.Load((ChunkAccess)chunk, false));
        return chunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void modifyChunkMaps(Consumer<Long2ObjectOpenHashMap<LevelChunk>> operation) {
        operation.accept(CHUNK_MAP);
        Long2ObjectOpenHashMap<LevelChunk> long2ObjectOpenHashMap = CHUNK_MAP_OTHER_THREADS;
        synchronized (long2ObjectOpenHashMap) {
            operation.accept(CHUNK_MAP_OTHER_THREADS);
        }
    }

    public static void clear() {
        CHUNK_MAP.clear();
        CHUNK_MAP_OTHER_THREADS.clear();
    }
}

