/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.EnumMap;
import java.util.Map;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.HangingSignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class SecretHangingSignBlockEntity
extends HangingSignBlockEntity
implements IOwnable,
IModuleInventory,
ICustomizable {
    private Owner owner = new Owner();
    private Option.BooleanOption isFrontSecret = new Option.BooleanOption(this, "isFrontSecret", true){

        @Override
        public String getKey(String denotation) {
            return "option.generic.secret_sign.isFrontSecret";
        }
    };
    private Option.BooleanOption isBackSecret = new Option.BooleanOption(this, "isBackSecret", true){

        @Override
        public String getKey(String denotation) {
            return "option.generic.secret_sign.isBackSecret";
        }
    };
    private NonNullList<ItemStack> modules = NonNullList.withSize((int)this.getMaxNumberOfModules(), (Object)ItemStack.EMPTY);
    private Map<ModuleType, Boolean> moduleStates = new EnumMap<ModuleType, Boolean>(ModuleType.class);

    public SecretHangingSignBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    public boolean isValidBlockState(BlockState state) {
        return this.getType().isValid(state);
    }

    public BlockEntityType<?> getType() {
        return (BlockEntityType)SCContent.SECRET_HANGING_SIGN_BLOCK_ENTITY.get();
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.saveAdditional(tag, lookupProvider);
        this.writeModuleInventory(tag, lookupProvider);
        this.writeModuleStates(tag);
        this.writeOptions(tag);
        if (this.owner != null) {
            this.owner.save(tag, this.needsValidation());
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.loadAdditional(tag, lookupProvider);
        this.modules = this.readModuleInventory(tag, lookupProvider);
        this.moduleStates = this.readModuleStates(tag);
        this.readOptions(tag);
        this.owner.load(tag);
    }

    @Override
    public void readOptions(CompoundTag tag) {
        if (tag.contains("isSecret")) {
            tag.putBoolean(this.isFrontSecret.getName(), tag.getBoolean("isSecret"));
            tag.remove("isSecret");
        }
        ICustomizable.super.readOptions(tag);
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.modules;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.isFrontSecret, this.isBackSecret};
    }

    public boolean isFrontSecret() {
        return (Boolean)this.isFrontSecret.get();
    }

    public boolean isBackSecret() {
        return (Boolean)this.isBackSecret.get();
    }

    public boolean isPlayerAllowedToSeeText(Player player, boolean isFront) {
        return !(isFront ? this.isFrontSecret() : this.isBackSecret()) || this.isOwnedBy((Entity)player) || this.isAllowed((Entity)player);
    }

    @Override
    public <T> void onOptionChanged(Option<T> option) {
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
        ICustomizable.super.onOptionChanged(option);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @Override
    public Owner getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String uuid, String name) {
        this.owner.set(uuid, name);
        this.setChanged();
    }

    @Override
    public boolean isModuleEnabled(ModuleType module) {
        return this.hasModule(module) && this.moduleStates.get((Object)module) == Boolean.TRUE;
    }

    @Override
    public void toggleModuleState(ModuleType module, boolean shouldBeEnabled) {
        this.moduleStates.put(module, shouldBeEnabled);
    }

    @Override
    public String getModuleDescriptionId(String denotation, ModuleType module) {
        return IModuleInventory.super.getModuleDescriptionId("generic.secret_sign", module);
    }

    @Override
    public Level myLevel() {
        return this.level;
    }

    @Override
    public BlockPos myPos() {
        return this.worldPosition;
    }
}

